% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subplot_sp.R
\name{subplot_sp}
\alias{subplot_sp}
\title{Plot a species subniche under each sub-environmental space K}
\usage{
subplot_sp(subnic, sp, main=NULL, col.axis="azure3", lty.axis=2, lwd.axis=2,
xlab=NULL, ylab=NULL, col.sublab="black", font.sublab=2, cex.sublab=0.7, show.lines=F,
border.E="#92c5de", col.E="#92c5de", lty.E=1, lwd.E=1, border.K ="#2c7fb8",lwd.K=1,
col.K ="#2c7fb8", lty.K=1, col.arrow="black",angle.arrow=20, lwd.arrow=2,
length.arrow=0.1, col.G_k= "red", cex.G_k=1, border.SP="#fec44f", col.SB="#d95f0e",
lty.SP=1, lwd.SP=1, border.NR ="#fdb462", col.NR =NA,cex.sp=1, col.sp="black",
border.SR="#a1d99b", col.SR="#a1d99b", col.SRc="black", lty.SR=1, lwd.SR=1, pch.SR=19,
cex.SR=1, lty.NR=1, lwd.NR=2, pch.G_k=19, col.su="#b35806", cex.su=0.5, pch.su=1,
posi.leg="topleft", bty.leg="n", ... )
}
\arguments{
\item{subnic}{an object of class \code{subniche}.}

\item{sp}{a character string of the species name.}

\item{main}{a main title for the plot, see \link[graphics]{title} for more details.}

\item{col.axis}{axis color, see \link[graphics]{par} for more details.}

\item{lty.axis}{axis line type, see \link[graphics]{par} for more details.}

\item{lwd.axis}{axis width, see \link[graphics]{par} for more details.}

\item{xlab}{label for x-axis, see \link[graphics]{title} for more details.}

\item{ylab}{label for y-axis, see \link[graphics]{title} for more details.}

\item{col.sublab}{color of the species labels, see \link[wordcloud]{textplot} for more details.}

\item{font.sublab}{font of the species labels, see \link[wordcloud]{textplot} for more details.}

\item{cex.sublab}{size of the species labels, see \link[wordcloud]{textplot} for more details.}

\item{show.lines}{if true, then lines are plotted between x,y and the word, for those words not covering their x,y coordinates. See \link[wordcloud]{textplot} for more details.}

\item{border.E}{color border of E polygon, see \link[graphics]{polygon} for more details.}

\item{col.E}{inside color of E polygon, see \link[graphics]{polygon} for more details.}

\item{lty.E}{line type for the E border, see \link[graphics]{polygon} for more details.}

\item{lwd.E}{line width for the E border, see \link[graphics]{polygon} for more details.}

\item{border.K}{color border of K polygon, see \link[graphics]{polygon} for more details.}

\item{lwd.K}{line width for the K border, see \link[graphics]{polygon} for more details.}

\item{col.K}{inside color of K polygon, see \link[graphics]{polygon} for more details.}

\item{lty.K}{line type for the K border, see \link[graphics]{polygon} for more details.}

\item{col.arrow}{arrow color, see \link[graphics]{arrows} for more details.}

\item{angle.arrow}{arrow angle head, see \link[graphics]{arrows} for more details.}

\item{lwd.arrow}{arrow width, see \link[graphics]{arrows} for more details.}

\item{length.arrow}{arrow head length, see \link[graphics]{arrows} for more details.}

\item{col.G_k}{color of the point representing G_k, see \link[graphics]{points} for more details.}

\item{cex.G_k}{size of the point representing G_k, see \link[graphics]{points} for more details.}

\item{border.SP}{color border of species subniche polygon, see \link[graphics]{polygon} for more details.}

\item{col.SB}{color of the SB area.}

\item{lty.SP}{line type for the SP border, see \link[graphics]{polygon} for more details.}

\item{lwd.SP}{line width for the SP border, see \link[graphics]{polygon} for more details.}

\item{border.NR}{color border of NR polygon, see \link[graphics]{polygon} for more details.}

\item{col.NR}{inside color of NR polygon, see \link[graphics]{polygon} for more details.}

\item{cex.sp}{size of the species label representing the NR position, see \link[wordcloud]{textplot} for more details.}

\item{col.sp}{color of the species label representing the NR position, see \link[wordcloud]{textplot} for more details.}

\item{border.SR}{color border of SR polygon, see \link[graphics]{polygon} for more details.}

\item{col.SR}{inside color of SR polygon, see \link[graphics]{polygon} for more details.}

\item{col.SRc}{color of points representing the SR position, see \link[graphics]{points} for more details.}

\item{lty.SR}{line type for the SR border, see \link[graphics]{polygon} for more details.}

\item{lwd.SR}{line width for the SR border, see \link[graphics]{polygon} for more details.}

\item{pch.SR}{type of points representing the SR position, see \link[graphics]{points} for more details.}

\item{cex.SR}{size of points representing the SR position, see \link[graphics]{points} for more details.}

\item{lty.NR}{line type for the NR border, see \link[graphics]{polygon} for more details.}

\item{lwd.NR}{line width for the NR border, see \link[graphics]{polygon} for more details.}

\item{pch.G_k}{type of the point representing G_k, see \link[graphics]{points} for more details.}

\item{col.su}{color of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{cex.su}{size of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{pch.su}{type of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{posi.leg}{legend location in the graph, see \link[graphics]{legend} for more details.}

\item{bty.leg}{the type of box to be drawn around the legends. The allowed values are "o" (the default) and "n". See \link[graphics]{legend} for more details}

\item{...}{further arguments passed to or from other methods.}
}
\description{
The function to represent the species subniche under each subenvironment K with their respective marginality from G_K.
}
\examples{
library(subniche)
data(doubs)
dudi1 <- dudi.pca(doubs$env, scale = TRUE, scan = FALSE, nf = 3)
nic1 <- niche(dudi1, doubs$fish, scann = FALSE)
# number of sites
N <- dim(nic1$ls)[1]
#Create a factor which defines the subsets
fact <- factor(c(rep(1,N/2),rep(2,N/2)))
# nic1 will be use as reference and fact will be use to define the subniches environment
subnic1 <- subniche(nic1, fact)
eig <- round(subnic1$eig/sum(subnic1$eig)*100,2)[1:2]
#Two graphs are drawn one after the other
subplot_sp(subnic1,"Neba",main="Species subniche in K")
}
