/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class AbstractClusterer
implements Clusterer,
Cloneable,
Serializable,
CapabilitiesHandler,
RevisionHandler {
    private static final long serialVersionUID = -6099962589663877632L;

    @Override
    public abstract void buildClusterer(Instances var1) throws Exception;

    @Override
    public int clusterInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        if (dist == null) {
            throw new Exception("Null distribution predicted");
        }
        if (Utils.sum(dist) <= 0.0) {
            throw new Exception("Unable to cluster instance");
        }
        return Utils.maxIndex(dist);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] d = new double[this.numberOfClusters()];
        d[this.clusterInstance((Instance)instance)] = 1.0;
        return d;
    }

    @Override
    public abstract int numberOfClusters() throws Exception;

    public static Clusterer forName(String clustererName, String[] options) throws Exception {
        return (Clusterer)Utils.forName(Clusterer.class, clustererName, options);
    }

    public static Clusterer makeCopy(Clusterer model) throws Exception {
        return (Clusterer)new SerializedObject(model).getObject();
    }

    public static Clusterer[] makeCopies(Clusterer model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model clusterer set");
        }
        Clusterer[] clusterers = new Clusterer[num];
        SerializedObject so = new SerializedObject(model);
        for (int i = 0; i < clusterers.length; ++i) {
            clusterers[i] = (Clusterer)so.getObject();
        }
        return clusterers;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAll();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6624 $");
    }

    public static void runClusterer(Clusterer clusterer, String[] options) {
        try {
            System.out.println(ClusterEvaluation.evaluateClusterer(clusterer, options));
        }
        catch (Exception e) {
            if (e.getMessage() == null || e.getMessage() != null && e.getMessage().indexOf("General options") == -1) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
    }
}

