% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_sg.R
\name{describe_sg}
\alias{describe_sg}
\title{Show descriptives for the sudden gains datasets}
\usage{
describe_sg(data, sg_data_structure = c("bysg", "byperson"))
}
\arguments{
\item{data}{A \code{bysg} or \code{byperson} dataset.}

\item{sg_data_structure}{String, indicating whether the input data is a \code{bysg} or \code{byperson} dataset.}
}
\value{
A list, showing basic descriptive statistics for sudden gains within the dataset specified.
Note that some numbers (e.g. percentages) will be different depending which dataset is selected, because where a participant has multiple gains, only one is selected for the \code{byperson} dataset.
The list includes values for:
  \itemize{
    \item{total_n}{: number of rows in input dataset}
    \item{sg_total_n}{: total number of sudden gains}
    \item{sg_n}{: number of people who experienced a sudden gain (byperson dataset only)}
    \item{sg_pct}{: percentage of people in the input dataset who experienced a sudden gain}
    \item{sg_multiple_n}{: number of people who experienced a sudden gain (byperson dataset only)}
    \item{sg_multiple_pct}{: percentage of people in the input dataset who experienced more than one sudden gain}
    \item{sg_reversal_n}{: number of sudden gains that later meets criteria for a reversal}
    \item{sg_reversal_pct}{: percentage of sudden gains that later meets criteria for a reversal}
    \item{sg_magnitude_m}{: mean magnitude of the sudden gains observed}
    \item{sg_magnitude_sd}{: standard deviation of the magnitude of the sudden gains observed}
    }
}
\description{
Some numbers (percentages) will be different depending wich dataset is selected, because if multiple gains in bysg only one will be selected for further analyses.
}
\examples{
# Create bysg dataset
bysg <- create_bysg(data = sgdata,
                    sg_crit1_cutoff = 7,
                    id_var_name = "id",
                    tx_start_var_name = "bdi_s1",
                    tx_end_var_name = "bdi_s12",
                    sg_var_list = c("bdi_s1", "bdi_s2", "bdi_s3",
                                    "bdi_s4", "bdi_s5", "bdi_s6",
                                    "bdi_s7", "bdi_s8", "bdi_s9",
                                    "bdi_s10", "bdi_s11", "bdi_s12"),
                    sg_measure_name = "bdi")

# Describe bysg dataset
describe_sg(data = bysg,
            sg_data_structure = "bysg")

# Create byperson dataset
byperson_first <- create_byperson(data = sgdata,
                                  sg_crit1_cutoff = 7,
                                  id_var_name = "id",
                                  tx_start_var_name = "bdi_s1",
                                  tx_end_var_name = "bdi_s12",
                                  sg_var_list = c("bdi_s1", "bdi_s2", "bdi_s3",
                                                  "bdi_s4", "bdi_s5", "bdi_s6",
                                                  "bdi_s7", "bdi_s8", "bdi_s9",
                                                  "bdi_s10", "bdi_s11", "bdi_s12"),
                                  sg_measure_name = "bdi",
                                  multiple_sg_select = "first")

# Describe byperson dataset
describe_sg(data = byperson_first,
            sg_data_structure = "byperson")
}
