% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_sl.R
\name{identify_sl}
\alias{identify_sl}
\title{Identify sudden losses.}
\usage{
identify_sl(data, id_var_name, sg_var_list, sg_crit1_cutoff,
  sg_crit2_pct = 0.25, sg_crit3 = TRUE, sg_crit3_alpha = 0.05,
  sg_crit3_adjust = TRUE, identify_sg_1to2 = FALSE,
  crit123_details = FALSE)
}
\arguments{
\item{data}{A data set in wide format including an ID variable and variables for each measurement point.}

\item{id_var_name}{String, specifying the name of the ID variable. Each row should have a unique value.}

\item{sg_var_list}{Vector, specifying the variable names of each measurement point sequentially.}

\item{sg_crit1_cutoff}{Numeric, specifying the negative cut-off value to be used for the first sudden losses criterion, see examples below.
The function \code{\link{define_crit1_cutoff}} can be used to calcualate a cutoff value based on the Reliable Change Index (RCI; Jacobson & Truax, 1991).
If set to \code{NULL} the first criterion wont be applied.}

\item{sg_crit2_pct}{Numeric, specifying the percentage change to be used for the second sudden losses criterion.
If set to \code{NULL} the first criterion wont be applied.}

\item{sg_crit3}{Logical, if set to \code{TRUE} the third criteria will be applied automatically adjusting the critical value for missingness.
If set to \code{FALSE} the third criterion wont be applied.}

\item{sg_crit3_alpha}{Numeric, alpha for the student t-test (two-tailed) to determine the critical value to be used for the third criterion.
Degrees of freedom are based on the number of available data in the three sessions preceding the loss and the three sessions following the loss.}

\item{sg_crit3_adjust}{Logical, specify whether critical value gets adjusted for missingness, see Lutz et al. (2013) and the documentation of this R package for further details.
This argument is set to \code{TRUE} by default adjusting the critical value for missingness as described in the package documentation and Lutz et al. (2013):
A critical value of 2.776 is used when all three data points before and after a potential gain are available,
where one datapoint is missing either before or after a potential gain a critical value of 3.182 is used,
and where one datapoint is missing both before and after the gain a critical value of 4.303 is used (for sg_crit3_alpha = 0.05).
If set to \code{FALSE} a critical value of 2.776 will instead be used for all comparisons, regardless of missingnes in the sequence of data points that are investigated for potential sudden gains.}

\item{identify_sg_1to2}{Logical, indicating whether to identify sudden losses from measurement point 1 to 2.
If set to TRUE, this implies that the first variable specified in \code{sg_var_list} represents a baseline measurement point, e.g. pre-intervention assessment.}

\item{crit123_details}{Logical, if set to \code{TRUE} this function returns information about which of the three criteria (e.g. "sg_crit1_2to3", "sg_crit2_2to3", and "sg_crit3_2to3") are met for each session to session interval for all cases.
Variables named "sg_2to3", "sg_3to4" summarise all criteria that were selected to identify sudden gains.}
}
\value{
A wide data set indicating whether sudden losses are present for each session to session interval for all cases in \code{data}.
}
\description{
Function to identify sudden losses in longitudinal data structured in wide format.
}
\examples{
# Identify sudden losses
identify_sl(data = sgdata,
            # Negative cut-off value to identify sudden losses
            sg_crit1_cutoff = -7,
            id_var_name = "id",
            sg_var_list = c("bdi_s1", "bdi_s2", "bdi_s3",
                            "bdi_s4", "bdi_s5", "bdi_s6",
                            "bdi_s7", "bdi_s8", "bdi_s9",
                            "bdi_s10", "bdi_s11", "bdi_s12"))
}
\references{
Lutz, W., Ehrlich, T., Rubel, J., Hallwachs, N., Röttger, M.-A., Jorasz, C., … Tschitsaz-Stucki, A. (2013). The ups and downs of psychotherapy: Sudden gains and sudden losses identified with session reports. Psychotherapy Research, 23(1), 14–24. \url{https://doi.org/10.1080/10503307.2012.693837}.

Tang, T. Z., & DeRubeis, R. J. (1999). Sudden gains and critical sessions in cognitive-behavioral therapy for depression. Journal of Consulting and Clinical Psychology, 67(6), 894–904. \url{https://doi.org/10.1037/0022-006X.67.6.894}.
}
