% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfSummary.R
\name{dfSummary}
\alias{dfSummary}
\title{Data frame Summary}
\usage{
dfSummary(x, round.digits = 2, varnumbers = TRUE,
  labels.col = length(label(x, all = TRUE)) > 0, valid.col = TRUE,
  na.col = TRUE, graph.col = TRUE, style = "multiline",
  plain.ascii = TRUE, justify = "left", omit.headings = FALSE,
  max.distinct.values = 10, trim.strings = FALSE, max.string.width = 25,
  split.cells = 40, split.table = Inf, ...)
}
\arguments{
\item{x}{A data frame.}

\item{round.digits}{Number of significant digits to display in numerical
summaries and in frequency proportions. Defaults to \code{2}.}

\item{varnumbers}{Logical. Should the first column contain variable number? Defaults
to \code{TRUE}.}

\item{labels.col}{Logical. If \code{TRUE}, variable labels (as defined with
\pkg{rapportools}, \pkg{Hmisc} or \pkg{summarytools}' \code{label} functions)
will be displayed. By default, the \emph{labels} column is shown if at least
one column has a defined label.}

\item{valid.col}{Logical. Include column indicating count and proportion of valid
(non-missing) values. \code{TRUE} by default.}

\item{na.col}{Logical. Include column indicating count and proportion of missing
(NA) values. \code{TRUE} by default.}

\item{graph.col}{Logical. Display barplots / histograms column in \emph{html}
reports. \code{TRUE} by default.}

\item{style}{Style to be used by \code{\link[pander]{pander}} when
rendering output table. Defaults to \dQuote{multiline}. The only other valid
option is \dQuote{grid}. Style \dQuote{simple} is not supported for this particular
function, and \dQuote{rmarkdown} will fallback to \dQuote{multiline}.}

\item{plain.ascii}{Logical. \code{\link[pander]{pander}} argument; When
\code{TRUE}, no markup characters will be generated (useful when printing
to console). Defaults to \code{TRUE}.}

\item{justify}{String indicating alignment of columns; one of \dQuote{l} (left)
\dQuote{c} (center), or \dQuote{r} (right). Defaults to \dQuote{l}.}

\item{omit.headings}{Logical. Set to \code{TRUE} to omit headings.}

\item{max.distinct.values}{The maximum number of values to display frequencies
for. If variable has more distinct values than this number, the remaining
frequencies will be reported as a whole, along with the number of additional
distinct values. Defaults to 10.}

\item{trim.strings}{Logical; for character variables, should leading and
trailing white space be removed? Defaults to \code{FALSE}. See \emph{details}
section.}

\item{max.string.width}{Limits the number of characters to display in the
frequency tables. Defaults to \code{25}.}

\item{split.cells}{A numeric argument passed to \code{\link[pander]{pander}}.
It is the number of characters allowed on a line before splitting the cell.
Defaults to \code{40}.}

\item{split.table}{\pkg{pander} argument which determines the maximum
width of a table. Keeping the default value (\code{Inf}) is recommended.}

\item{\dots}{Additional arguments passed to \code{\link[pander]{pander}}.}
}
\value{
A data frame containing as many rows as there are columns in \code{x},
  with additional attributes to inform \code{print} function. Columns of the
  output data frame are:
  \describe{
    \item{No}{Number indicating the order in which column appears in
      the data frame.}
    \item{Variable}{Name of the variable, along with its class(es).}
    \item{Label}{Label of the variable (if applicable).}
    \item{Stats / Values}{For factors, a list of their values, limited by the
      \code{max.distinct.values} parameter. For character variables, the most
      common values (in descending frequency order), also limited by
      \code{max.distinct.values}. For numerical variables, common univariate
      statistics (mean, std. deviation, min, med, max, IQR and CV).}
    \item{Freqs (\% of Valid)}{For factors and character variables, the frequencies
      and proportions of the values listed in the previous column. For numerical
      vectors, number of distinct values, or frequency of distinct values if
      their number is not greater than \code{max.distinct.values}.}
    \item{Text Graph}{An ascii histogram for numerical variables, and ascii
      barplot for factors and character variables.}
    \item{Valid}{Number and proportion of valid values.}
    \item{Missing}{Number and proportion of missing (NA) values, including NaN's.}
}
}
\description{
Summary of a data frame consisting of: variable names, labels if any, factor
levels, frequencies and/or numerical summary statistics, and valid/missing
observation counts.
}
\details{
The default \code{plain.ascii = TRUE} option is there to make results
  appear cleaner in the console. When used in a context of \emph{rmarkdown} rendering,
  set this option to \code{FALSE}.

  When the \code{trim.strings} is set to \code{TRUE}, trimming is done
  \emph{before} calculating frequencies, so those will be impacted
  accordingly.
}
\examples{
data(tobacco)
dfSummary(tobacco)
\dontrun{view(dfSummary(iris))}

}
\seealso{
\code{\link[base]{summary.data.frame}}
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{attribute}
\keyword{category}
\keyword{classes}
\keyword{univar}
