% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_summclust.R
\name{summary.summclust}
\alias{summary.summclust}
\title{A \code{summary()} method for objects of type \code{summclust}}
\usage{
\method{summary}{summclust}(object, ...)
}
\arguments{
\item{object}{An object of type summclust}

\item{...}{misc arguments}
}
\value{
A printed summary with pvalues, t-statistics, confidence intervals,
and leverage statistics
}
\description{
A \code{summary()} method for objects of type \code{summclust}
}
\examples{

library(summclust)
data(mtcars)
mtcars

fit <- lm(mpg ~ cyl + disp + hp, data = mtcars)
summ <- summclust(fit, params = ~cyl + disp, cluster = ~carb)
summary(summ)
tidy(summ)
plot(summ)

}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
