% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WelchDegreeOfFreedom.R
\name{WelchDegreeOfFreedom}
\alias{WelchDegreeOfFreedom}
\title{Welch's rectified degree of freedom}
\usage{
WelchDegreeOfFreedom(dta, cols, groupingcols)
}
\arguments{
\item{dta}{A data frame containing within-subject measures, one participant per line;}

\item{cols}{A vector indicating the columns containing the measures.}

\item{groupingcols}{A vector indicating the columns containing the groups.}
}
\value{
df the degrees of freedom rectified according to Welch (1947).
}
\description{
When variance across groups are heterogeneous,
the Student \code{t} distribution with \code{n - 1} df is not the exact distribution.
However, Welch (1947), using methods of moments, was able to find the
best-fitting \code{t} distribution. This distribution has degree of freedom reduced
based on the sample sizes and the variances of the group tests. The present
function returns the rectified degree of freedom
}
\examples{
# creates a small data frames with 4 subject's scores for 5 measures:
dta <- data.frame(cbind(
        DV.1 = c(3., 6., 2., 2., 5.),
        DV.2 = c(4., 5., 4., 4., 3.),
        DV.3 = c(2., 7., 7., 8., 6.),
        DV.4 = c(6., 8., 4., 6., 5.),
        grp  = c(1., 1., 2., 2., 2.)
    ))
# performs the test (here rectified df = 1.898876)
WelchDegreeOfFreedom(dta, "DV.1","grp")

}
\references{
\insertAllCited{}
}
