% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVMTrainer.R
\docType{data}
\name{SVMTrainer}
\alias{SVMTrainer}
\title{Support Vector Machines Trainer}
\format{\code{\link{R6Class}} object.}
\usage{
SVMTrainer
}
\description{
Trains a support vector machine (svm) model. It is based on the magnificently fast speed liquidSVM R package.
It provides a more unified interface over the package retaining all its functionality.

The model is intelligently trained with a default set of hyper parameters. Also, there are inbuilt
grid setups which can be easily initialised. It has capability to support batch processing of data
to avoid memory errors. It supports binary classification, multi classification, regression models
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
svm = SVMTrainer$new(type=NULL,scale=TRUE, gammas=NULL, lambdas=NULL, c_values=NULL,
                     predict.prob=FALSE, verbose=NULL, ncores=NULL, partition_choice=0,
                     seed=-1, grid_choice=NULL, useCells=FALSE, mc_type=NULL,
                     adaptivity_control=0)
svm$fit(X_train, y_train)
prediction <- svm$predict(X_test)
}
}

\section{Methods}{

\describe{
  \item{\code{$new()}}{Initialises an instance of svm model}
  \item{\code{$fit()}}{fits model to an input train data and trains the model.}
  \item{\code{$predict()}}{returns predictions by fitting the trained model on test data.}
}
}

\section{Arguments}{

\describe{
 \item{params}{for detailed explanation on parameters,
             refer to original documentation https://cran.r-project.org/web/packages/e1071/e1071.pdf}
 \item{type}{type of model to train, possible values: "bc" = binary classification, "mc" = multiclassification,
              "ls" = least square regression, "qt" = quantile regression}
 \item{scale}{normalises the feature between 0 and 1, default = TRUE}
 \item{gammas}{bandwidth of the kernel, default value is chosen from a list of gamma values generated internally}
}
}

\examples{
data(iris)
## Multiclassification
svm <- SVMTrainer$new()
svm$fit(iris, "Species")
p <- svm$predict(iris)

## Least Squares
svm <- SVMTrainer$new()
svm$fit(trees, "Height")
p <- svm$predict(trees)
}
\keyword{datasets}
