% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.skew.R
\name{se.skew}
\alias{se.skew}
\title{Standard Error of Skewness}
\usage{
se.skew(x)
}
\arguments{
\item{x}{numeric object containing the values for a variable.}
}
\value{
Standard error of skewness for \code{x}.
}
\description{
Function to obtain the standard error of the skewness of a distribution of values.
}
\details{
Standard error of skewness is computed on non-missing values using the following equation. \deqn{\sqrt( 6*N*(N-1) / ((N-2)*(N+1)*(N+3)) )}
}
\examples{
se.skew(Temp$Temperature[Temp$City == "Springfield"])
se.skew(Temp$Temperature[Temp$City == "SanFrancisco"])
}
\seealso{
\code{\link[sur]{skew}}, \code{\link[sur]{skew.ratio}}
}
