% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.transition.probs.R
\name{make_data_multi_state}
\alias{make_data_multi_state}
\title{make_data_multi_state}
\usage{
make_data_multi_state(
  data,
  id = "id",
  prog = "prog",
  death = "death",
  prog_t = "prog_t",
  death_t = "death_t",
  keep = NULL,
  ...
)
}
\arguments{
\item{data}{dataset containing the full ILD with information on both
progression and death. Can be a data.frame or a tibble}

\item{id}{The column with the individual identifier. Can be NULL (in
which case, it will be created from scratch)}

\item{prog}{The progression indicator: takes value 1 if the individual
has progressed and 0 otherwise. Defaults to the column named 'prog' in
the dataset}

\item{death}{The death indicator: takes value 1 if the individual
has died and 0 otherwise. Defaults to the column named 'death' in
the dataset}

\item{prog_t}{The progression time. Defaults to the column named
'prog_t' in the dataset}

\item{death_t}{The death time. Defaults to the column named
'death_t' in the dataset}

\item{keep}{A vector of strings with the names of the additional
variables from the original dataset to keep into the multistate
dataset. If 'NULL' (default), then keeps all}

\item{...}{additional arguments.}
}
\value{
A tibble containing the event history for each individual
and with the following variables: id = Patients ID; from = Initial
state (1=Pre-progression, 2=Progression, 3=Death); to = End state
(1=Pre-progression, 2=Progression, 3=Death); trans = Transition ID:
1=Pre-progression -> Progression; 2=Pre-Progression -> Death;
3=Progression -> Death; Tstart = Entry time (either entry or
progression); Tstop = Exit time (time of event or censoring time);
status = Event indicator (1=yes, 0=censored), \strong{for the specific
event under consideration}; treat = Treatment indicator
All the other original variables are appended to these, but can be
removed
}
\description{
Takes as input an individual-level dataset including data on both
progression and death time (\strong{jointly}) and manipulates it using
\code{dplyr} functions to create a full "multi-state" dataset, in
which all the transitions are tracked. This can then be used
to fit survival models and compute all the estimates for the
whole set of transition probabilities
}
\note{
Something will go here
}
\examples{
\dontrun{
# Something will go here
}

}
\references{
Something will go here
}
\seealso{
Something will go here
}
\author{
Gianluca Baio
}
\keyword{Markov}
\keyword{Multistate}
\keyword{Transition}
\keyword{models}
\keyword{probabilities}
