% Generated by roxygen2 (4.0.1): do not edit by hand
\name{autoplot.rpart}
\alias{autoplot}
\alias{autoplot.rpart}
\title{Generate a \code{ggplot} for an \code{rpart} object}
\usage{
autoplot(object, ...)

\method{autoplot}{rpart}(object, ...,
  title = "Recursive partitioning tree \\n Terminal nodes show fitted response",
  titSize = 20, uniform = FALSE, minbranch = 0.3, compress = FALSE,
  nspace, branch = 1, all = TRUE, nodeLabels = NULL, lineSize = 1,
  vArrows = FALSE, nodeSize = 5, nodeColor = "darkblue",
  leaf = c("fitR", "en", "both"), leafSize = 5, leafColor = "darkblue",
  digits = NULL, yNU = 0.02, yND = 0.02, yLD = 0.02)
}
\arguments{
\item{object}{An object of class \code{rpart}, as returned by \code{rpart::rpart()}}

\item{...}{Additional arguments (not implemented)}

\item{title}{Title for plot}

\item{titSize}{Title text size}

\item{uniform}{The default is to use a non-uniform spacing
\emph{proportional to the error in the fit}.
\cr
If \code{uniform=TRUE}, uniform vertical spacing of the nodes is used.
\cr
This may be less cluttered when fitting a large plot onto a page.}

\item{minbranch}{This parameter is ignored if \code{uniform=TRUE}.
\cr
The usual tree shows branch lengths \emph{in proportion to improvement}.
\cr
Where improvement is
minimal, there may be insuffcient room for node labels.
\code{minbranch} sets the minimum length for a branch to \code{minbranch}
times the average branch length.}

\item{compress}{If \code{compress=FALSE} (the default), the leaves
(terminal nodes) will be at the horizontal plot co-ordinates of \eqn{1:l},
the number of \bold{l}eaves.
\cr
If \code{compress=TRUE}, the tree is arranged in a more compact form.
\cr
(The compaction algorithm assumes \code{uniform=TRUE}.
The result is usually an improvement even when this is not the case.)}

\item{nspace}{Applies only when \code{compress=TRUE}.
\cr
The amount of extra space between a node with children and a leaf,
as compared to the minimal space between leaves.
\cr
The default is the value of \code{branch}, below.}

\item{branch}{Controls the shape of the branches from parent to child node.
\cr
Needs to be in the range \eqn{0-1}.
\cr
A value of \eqn{1} gives square shouldered branches.
\cr
A value of \eqn{0} gives 'V' shaped branches, with other values being intermediate.}

\item{all}{If \code{all="FALSE"} only terminal nodes
(i.e. leaves) will be labelled}

\item{nodeLabels}{These can be used to replace the names of the
default labels from the fit.
\cr
Should be given in the same order as those names}

\item{lineSize}{Line size connecting nodes}

\item{vArrows}{If \code{vArrows=TRUE}, adds vertical arrows for descending lines}

\item{nodeSize}{Node text size}

\item{nodeColor}{Node text color}

\item{leaf}{If \code{leaf="fitR"} (the default) leaves
are labelled with the fitted response. If this is a \code{factor}, the
\code{labels} of the \code{factor} are used.
\cr
The following apply only when the object is fit with
\code{rpart(..., method="exp")}:
\itemize{
 \item If \code{leaf="en"}, the leaves are labelled with number of
\bold{e}vents and the \bold{n}umber at risk.
 \item If \code{leaf="both"} labels show both fitted responses and
number of events/ number at risk.
 }}

\item{leafSize}{Leaf (terminal node) text size}

\item{leafColor}{Leaf text color}

\item{digits}{Number of significant digits for fitted response.
\cr
Default is \code{getOption("digits")}}

\item{yNU}{\bold{y} value for \bold{N}odes moved \bold{U}p.
Used to prevent text from overlapping.
\cr
This multiplier is applied to the difference
of the largest and smallest \eqn{y} values plotted.
\cr
May need to be increased if larger text sizes are
used in labelling nodes or node labels span > 1 line.
\cr
Typically is \eqn{< 0.1}.}

\item{yND}{\bold{y} value for \bold{N}odes moved \bold{D}own.
\cr
As above, but applies to text appearing
below the node.}

\item{yLD}{\bold{y} value for \bold{L}eaves moved \bold{D}own.
\cr
As above, but applies to text appearing
below the leaves.}
}
\value{
A \code{list} with the following elmenents:
\describe{
  \item{plot}{A plot, as generated by \code{ggplot}}
  \item{segments}{A \code{data.table} with the co-ordinates used to plot the lines}
  \item{nodes}{A \code{data.table} with the co-ordinates used to plot the nodes.
               \cr
               Columns are labelled as follows:
               \describe{
                 \item{x, y}{\eqn{x} and \eqn{y} co-ordinates}
                 \item{node}{Node name}
                 \item{n}{Number of observations (number at risk) for this node}
                 \item{isP}{Is node a \bold{p}arent?}
                 \item{lC, rC}{Left and right \bold{c}hildren of node}
                 \item{isL}{Is node a \bold{l}eaf (terminal node)?}
                 \item{resp}{Predicted \bold{resp}onse}
                 \item{yNU, yND, yLD}{adjusted \eqn{y} values for
                                      \cr
                                      \bold{n}odes (\bold{u}p and \bold{d}down) and
                                      \cr
                                      \bold{l}eaves (\bold{d}own)}
               }
               And where applicable:
               \describe{
                 \item{e}{Number of events}
                 \item{en}{Number of events / number of observations}
               }
  }
}
}
\description{
Uses \code{ggplot2} to render a recursive partitioning tree.
}
\details{
The plot shows a division at each node. This is read as \emph{right=TRUE}.
\cr
Thus for a node reading \bold{x > 0.5}
the line descending to the right is that where \bold{x > 0.5}.
}
\examples{
data("cu.summary", package="rpart")
fit <- rpart::rpart(Price ~ Mileage + Type + Country, data=cu.summary)
autoplot(fit)
data("stagec", package="rpart")
progstat <- factor(stagec$pgstat, levels = 0:1, labels = c("No", "Prog"))
cfit <- rpart::rpart(progstat ~ age + eet + g2 + grade + gleason + ploidy,
                     data=stagec, method="class")
autoplot(cfit)
set.seed(1)
df1 <- genSurvDf(model=FALSE)
r1 <- rpart::rpart(Surv(t1, e) ~ ., data=df1, method="exp")
autoplot(r1, leaf="en", title="Nodes show events / no. at risk")
autoplot(r1, compress=TRUE, branch=0.5, nspace=0.1,
         title="Nodes show events / no. at risk")
### oversize text; need to adjust y values for text to compensate
a1 <- autoplot(r1, compress=TRUE, digits=5,
               nodeSize=10, yNU=0.05, yND=0.03,
               leafSize=10, , yLD=0.08, nodeLabels=seq(17))$plot
### can use expand_limits if text is cut off at margins
a1 + ggplot2::expand_limits(x=c(0.75, 7.25))
}
\author{
Chris Dardis. Adapted from work by Andrie de Vries and Terry Therneau.
}
\keyword{graphs}

