% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_52.r
\name{tensor.prod.S}
\alias{tensor.prod.S}
\title{Tensor product for penalty matrices}
\usage{
tensor.prod.S(S)
}
\arguments{
\item{S}{list of m marginal penalty matrices}
}
\value{
\item{TS}{List of the penalty matrices associated with the tensor product smooth}
}
\description{
Computes the penalty matrices of a tensor product smooth from the marginal penalty matrices. The code is from
function \code{tensor.prod.penalties} in \code{mgcv} package.
}
\examples{

library(survPen)

# tensor product between three penalty matrices
set.seed(15)

S1 <- matrix(rnorm(3*3),nrow=3,ncol=3)
S2 <- matrix(rnorm(2*2),nrow=2,ncol=2)

S1 <- 0.5*(S1 + t(S1) ) ; S2 <- 0.5*(S2 + t(S2) )

tensor.prod.S(list(S1,S2))

}
