% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV2_00.r
\name{survPenObject}
\alias{survPenObject}
\title{Fitted survPen object}
\value{
A \code{survPen} object has the following elements:
\item{call}{original \code{survPen} call}
\item{formula}{formula object specifying the model}
\item{t0.name}{name of the vector of origin times}
\item{t1.name}{name of the vector of follow-up times}
\item{event.name}{name of the vector of right-censoring indicators}
\item{expected.name}{name of the vector of expected hazard}
\item{haz}{fitted hazard}
\item{coefficients}{estimated regression parameters. Unpenalized parameters are first, followed by the penalized ones}
\item{type}{"net" for net survival estimation with penalized excess hazard model, "overall" for overall survival with penalized hazard model, or "mult" for penalized relative mortality ratio model}
\item{df.para}{degrees of freedom associated with fully parametric terms (unpenalized)}
\item{df.smooth}{degrees of freedom associated with penalized terms}
\item{p}{number of regression parameters}
\item{edf}{effective degrees of freedom}
\item{edf1}{alternative effective degrees of freedom ; used as an upper bound for edf2}
\item{edf2}{effective degrees of freedom corrected for smoothing parameter uncertainty}
\item{aic}{Akaike information criterion with number of parameters replaced by edf when there are penalized terms. Corresponds to 2*edf - 2*ll.unpen}
\item{aic2}{Akaike information criterion corrected for smoothing parameter uncertainty. Be careful though, this is still a work in progress, especially when one of the smoothing parameters tends to infinity.}
\item{iter.beta}{vector of numbers of iterations needed to estimate the regression parameters for each smoothing parameters trial. It thus contains \code{iter.rho+1} elements.}
\item{X}{design matrix of the model}
\item{S}{penalty matrix of the model}
\item{S.scale}{vector of rescaling factors for the penalty matrices}
\item{S.list}{Equivalent to pen but with every element multiplied by its associated smoothing parameter}
\item{S.smf}{List of penalty matrices associated with all "smf" calls}
\item{S.tensor}{List of penalty matrices associated with all "tensor" calls}
\item{S.tint}{List of penalty matrices associated with all "tint" calls}
\item{S.rd}{List of penalty matrices associated with all "rd" calls}
\item{smooth.name.smf}{List of names for the "smf" calls associated with S.smf}
\item{smooth.name.tensor}{List of names for the "tensor" calls associated with S.tensor}
\item{smooth.name.tint}{List of names for the "tint" calls associated with S.tint}
\item{smooth.name.rd}{List of names for the "rd" calls associated with S.rd}
\item{S.pen}{List of all the rescaled penalty matrices redimensioned to df.tot size. Every element of \code{S.pen} noted \code{S.pen[[i]]} is made from a penalty matrix \code{pen[[i]]} returned by
\code{\link{smooth.cons}} and is multiplied by S.scale}
\item{grad.unpen.beta}{gradient vector of the log-likelihood with respect to the regression parameters}
\item{grad.beta}{gradient vector of the penalized log-likelihood with respect to the regression parameters}
\item{Hess.unpen.beta}{hessian of the log-likelihood with respect to the regression parameters}
\item{Hess.beta}{hessian of the penalized log-likelihood with respect to the regression parameters}
\item{Hess.beta.modif}{if TRUE, the hessian of the penalized log-likelihood has been perturbed at convergence}
\item{ll.unpen}{log-likelihood at convergence}
\item{ll.pen}{penalized log-likelihood at convergence}
\item{deriv.rho.beta}{transpose of the Jacobian of beta with respect to the log smoothing parameters}
\item{deriv.rho.inv.Hess.beta}{list containing the derivatives of the inverse of \code{Hess} with respect to the log smoothing parameters}
\item{deriv.rho.Hess.unpen.beta}{list containing the derivatives of \code{Hess.unpen} with respect to the log smoothing parameters}
\item{lambda}{estimated or given smoothing parameters}
\item{nb.smooth}{number of smoothing parameters}
\item{iter.rho}{number of iterations needed to estimate the smoothing parameters}
\item{optim.rho}{identify whether the smoothing parameters were estimated or not; 1 when exiting the function \code{\link{NR.rho}}; default is NULL}
\item{method}{criterion used for smoothing parameter estimation}
\item{criterion.val}{value of the criterion used for smoothing parameter estimation at convergence}
\item{LCV}{Likelihood cross-validation criterion at convergence}
\item{LAML}{negative Laplace approximate marginal likelihood at convergence}
\item{grad.rho}{gradient vector of criterion with respect to the log smoothing parameters}
\item{Hess.rho}{hessian matrix of criterion with respect to the log smoothing parameters}
\item{inv.Hess.rho}{inverse of \code{Hess.rho}}
\item{Hess.rho.modif}{if TRUE, the hessian of LCV or LAML has been perturbed at convergence}
\item{Ve}{Frequentist covariance matrix}
\item{Vr}{Robust frequentist covariance matrix accounting for correlated survival times}
\item{Vp}{Bayesian covariance matrix}
\item{Vc}{Bayesian covariance matrix corrected for smoothing parameter uncertainty (see Wood et al. 2016)}
\item{Vc.approx}{Kass and Steffey approximation of \code{Vc} (see Wood et al. 2016)}
\item{Z.smf}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{smf}} splines}
\item{Z.tensor}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{tensor}} splines}
\item{Z.tint}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{tint}} splines}
\item{list.smf}{List of all \code{smf.smooth.spec} objects contained in the model}
\item{list.tensor}{List of all \code{tensor.smooth.spec} objects contained in the model}
\item{list.tint}{List of all \code{tint.smooth.spec} objects contained in the model}
\item{list.rd}{List of all \code{rd.smooth.spec} objects contained in the model}
\item{U.F}{Eigen vectors of S.F, useful for the initial reparameterization to separate penalized ad unpenalized subvectors. Allows stable evaluation of the log determinant of S and its derivatives}
\item{is.pwcst}{TRUE if there is a piecewise constant (excess) hazard specification. In that case the cumulative hazard can be derived without Gauss-Legendre quadrature}
\item{pwcst.breaks}{if is.pwcst is TRUE, vector of breaks defining the sub-intervals on which the hazard is constant. Otherwise NULL.}
\item{factor.structure}{List containing the levels and classes of all factor variables present in the data frame used for fitting}
\item{converged}{convergence indicator, TRUE or FALSE. TRUE if Hess.beta.modif=FALSE and Hess.rho.modif=FALSE (or NULL)}
}
\description{
A fitted survPen object returned by function \code{\link{survPen}} and of class "survPen". 
Method functions predict and summary are available for this class.
}
\references{
Wood, S.N., Pya, N. and Saefken, B. (2016), Smoothing parameter and model selection for general smooth models (with discussion). Journal of the American Statistical Association 111, 1548-1575
}
