% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apc.R
\name{print.apc}
\alias{print.apc}
\alias{plot.apc}
\title{Methods for APC objects}
\usage{
\method{print}{apc}(x, digits = 1, max = 20, ...)

\method{plot}{apc}(
  x,
  cumulative = FALSE,
  style = c("mean_qi", "lines"),
  M = 250,
  col = "black",
  fill = "black",
  alpha,
  lwd,
  base_size = 14,
  ...
)
}
\arguments{
\item{x}{An \code{apc} object returned by \code{\link[surveil]{apc}}}

\item{digits}{Print this many digits (passed to \code{\link[base]{print.data.frame}})}

\item{max}{Maximum number of time periods (rows) to print}

\item{...}{additional arguments; for the print argument, these will be passed to \code{\link[base]{print.data.frame}}. For the plot method, these will be passed to \code{\link[ggplot2]{theme}}.}

\item{cumulative}{Plot cumulative percent change? Defaults to \code{cumulative = FALSE}}

\item{style}{If \code{style = "mean_qi"}, then the posterior mean and 95 percent credible interval will be plotted; if \code{style = "lines"}, then \code{M} samples from the joint probability distribution will be plotted.}

\item{M}{If \code{style = "lines"}, then \code{M} is the number of samples from the posterior distribution that will be plotted; the default is \code{M = 250}.}

\item{col}{Line color}

\item{fill}{Fill color for the 95 percent credible interval}

\item{alpha}{For \code{style = "mean_qi"}, this controls the transparency for the credible interval (passed to \code{\link[ggplot2]{geom_ribbon}}) and defaults to \code{alpha = 0.5}; for \code{style = "lines"}, this controls the transparency of the lines and defaults to \code{alpha = 0.7}.}

\item{lwd}{Line width}

\item{base_size}{Size of plot attributes, passed to `\code{\link[ggplot2]{theme_classic}}}
}
\value{
\subsection{print}{

The print method does not have a return value, but prints a summary of results to the R console.
}

\subsection{Plot}{

The plot method returns a \code{ggplot}.
}
}
\description{
Methods for APC objects
}
\seealso{
\code{\link[surveil]{apc}}
}
