% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{priors}
\alias{priors}
\alias{normal}
\alias{lkj}
\title{Prior distributions}
\source{
Stan Development Team. Stan Functions Reference Version 2.27. \url{https://mc-stan.org/docs/2_27/functions-reference/lkj-correlation.html}
}
\usage{
normal(location = 0, scale, k = 1)

lkj(eta)
}
\arguments{
\item{location}{Location parameter (numeric)}

\item{scale}{Scale parameter (positive numeric)}

\item{k}{Optional; number of groups for which priors are needed. This is a shortcut to avoid using the \code{rep} function to repeat the same prior for each group, as in: \verb{normal(location = rep(0, times = 3), scale = rep(1, times = 3)}. To provide distinct priors for each group, simply specify them individually, as in \code{normal(location = c(-5, -6, -8), scale = c(2, 2, 2))}.}

\item{eta}{The shape parameter for the LKJ prior}
}
\value{
An object of class \code{prior} which will be used internally by \strong{surveil} to set parameters of prior distributions.
}
\description{
Prior distributions
}
\details{
The prior distribution functions are used to set the values of prior parameters.

Users can control the values of the parameters, but the distribution (model) itself is fixed. The first log-rate (\code{eta[t]}, \code{t=1}) and the scale parameters (sigma) are assigned Gaussian (\code{normal}) prior distribution. (The scale parameter, sigma, is constrained to be positive, making it a half-normal prior.) For correlated time series, the correlation matrix is assigned the LKJ prior.
\subsection{Parameterizations}{

For details on how any distribution is parameterized, see the Stan Language Functions Reference document: \url{https://mc-stan.org/users/documentation/}.
}

\subsection{LKJ prior}{

The LKJ prior for correlation matrix has a single parameter, eta (eta > 0). If \code{eta=1}, then you are placing a uniform prior on any K-by-K correlation matrix. For eta > 1, there is a higher probability on the identity matrix, such that as eta increases beyond 1, you are expressing greater skepticism towards large correlations. If 0 < eta < 1, then you will be expressing skepticism towards correlations of zero and favoring non-zero correlations. See Stan documentation: \url{https://mc-stan.org/docs/2_27/functions-reference/lkj-correlation.html}.
}
}
\examples{

# note there are three groups in the data, each requires a prior
prior <- list()
prior$eta_1 <- normal(location = -6, scale = 4, k = 3)
## by default, location = 0
prior$sigma <- normal(scale = 1, k = 3)
prior$omega <- lkj(2)

\donttest{
dfw <- msa[grep("Dallas", msa$MSA), ]
fit <- stan_rw(dfw, time = Year, group = Race, prior = prior,
               chains = 2, iter = 900) # for speed only
plot(fit)
}

}
