% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{brier_score}
\alias{brier_score}
\alias{loss_brier_score}
\title{Calculate Brier score}
\usage{
brier_score(y_true = NULL, risk = NULL, surv = NULL, times = NULL)

loss_brier_score(y_true = NULL, risk = NULL, surv = NULL, times = NULL)
}
\arguments{
\item{y_true}{a \code{survival::Surv} object containing the times and statuses of observations for which the metric will be evaluated}

\item{risk}{ignored, left for compatibility with other metrics}

\item{surv}{a matrix containing the predicted survival functions for the considered observations, each row represents a single observation, whereas each column one time point}

\item{times}{a vector of time points at which the survival function was evaluated}
}
\value{
numeric from 0 to 1, lower scores are better (brier score of 0.25 represents a model which returns always returns 0.5 as the predicted survival function)
}
\description{
A function for calculating the Brier score for a survival model.
}
\details{
Brier score is used to evaluate the performance of a survival model, based on the squared distance between the predicted survival function and the actual event time, weighted to account for censored observations.
}
\examples{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
cph_exp <- explain(cph)

y <- cph_exp$y
times <- cph_exp$times
surv <- cph_exp$predict_survival_function(cph, cph_exp$data, times)

brier_score(y, surv = surv, times = times)
loss_brier_score(y, surv = surv, times = times)

}
\seealso{
\code{\link[=cd_auc]{cd_auc()}}
}
