% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_surv_model_performance.R
\name{plot.surv_model_performance}
\alias{plot.surv_model_performance}
\title{Plot Model Performance Metrics for Survival Models}
\usage{
\method{plot}{surv_model_performance}(
  x,
  ...,
  metrics = NULL,
  metrics_type = "time_dependent",
  title = "Model performance",
  subtitle = NULL,
  facet_ncol = NULL,
  colors = NULL
)
}
\arguments{
\item{x}{an object of class \code{"surv_model_performance"} to be plotted}

\item{...}{additional objects of class \code{"surv_model_performance"} to be plotted together}

\item{metrics}{character, names of metrics to be plotted (subset of C/D AUC", "Brier score" for \code{metrics_type \%in\% c("time_dependent", "functional")} or subset of "C-index","Integrated Brier score", "Integrated C/D AUC" for \code{metrics_type == "scalar"}), by default (\code{NULL}) all metrics of a given type are plotted}

\item{metrics_type}{character, either one of \code{c("time_dependent","functional")} for functional metrics or \code{"scalar"} for scalar metrics}

\item{title}{character, title of the plot}

\item{subtitle}{character, subtitle of the plot, if \code{NULL} automaticaly generated as "created for XXX, YYY models", where XXX and YYY are explainer labels}

\item{facet_ncol}{number of columns for arranging subplots}

\item{colors}{character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")}
}
\value{
A \code{ggplot2} plot.
}
\description{
This function plots objects of class \code{"surv_model_performance"} - visualization of metrics of different models
}
\examples{
library(survival)
library(survex)

model <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)
exp <- explain(model)

m_perf <- model_performance(exp)
plot(m_perf)

}
\seealso{
Other functions for plotting 'model_performance_survival' objects: 
\code{\link{plot.model_performance_survival}()},
\code{\link{plot.surv_model_performance_rocs}()}
}
\concept{functions for plotting 'model_performance_survival' objects}
