% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_shap.R
\name{surv_shap}
\alias{surv_shap}
\title{Helper functions for \code{predict_parts.R}}
\usage{
surv_shap(
  explainer,
  new_observation,
  output_type,
  ...,
  y_true = NULL,
  calculation_method = "kernelshap",
  aggregation_method = "integral"
)
}
\arguments{
\item{explainer}{an explainer object - model preprocessed by the \code{explain()} function}

\item{new_observation}{new observations for which predictions need to be explained}

\item{output_type}{a character, either \code{"survival"} or \code{"chf"}. Determines which type of prediction should be used for explanations.}

\item{...}{additional parameters, passed to internal functions}

\item{y_true}{a two element numeric vector or matrix of one row and two columns, the first element being the true observed time and the second the status of the observation, used for plotting}

\item{calculation_method}{a character, either \code{"kernelshap"} for use of \code{kernelshap} library (providing faster Kernel SHAP with refinements) or \code{"exact_kernel"} for exact Kernel SHAP estimation}

\item{aggregation_method}{a character, either \code{"integral"}, \code{"integral_absolute"}, \code{"mean_absolute"}, \code{"max_absolute"}, or \code{"sum_of_squares"}}
}
\value{
A list, containing the calculated SurvSHAP(t) results in the \code{result} field
}
\description{
Helper functions for \code{predict_parts.R}
}
\section{References}{

\itemize{
\item [1] Krzyziński, Mateusz, et al. \href{https://www.sciencedirect.com/science/article/pii/S0950705122013302}{"SurvSHAP(t): Time-dependent explanations of machine learning survival models."} Knowledge-Based Systems 262 (2023): 110234
}
}

\keyword{internal}
