## Paley construction of Hadamard matrices
## Only implemented for GF(p), because it's
## not entirely straightforward to find
## representations of GF(p^m)

paley<-function(n, nmax=2*n, prime=NULL, check=!is.null(prime)){

  if(!is.null(prime) && missing(n)) n<-prime

  ## these are primes with p+1 a multiple of 4
  small.primes<-c(3, 7, 11, 19, 23, 31, 43, 47, 59, 67, 71, 79, 83, 103, 107, 
                  127, 131, 139, 151, 163, 167, 179, 191, 199, 211, 223, 227, 239, 
                  251, 263, 271, 283, 307, 311, 331, 347, 359, 367, 379, 383, 419, 
                  431, 439, 443, 463, 467, 479, 487, 491, 499, 503, 523, 547, 563, 
                  571, 587, 599, 607, 619, 631, 643, 647, 659, 683, 691, 719, 727, 
                  739, 743, 751, 787, 811, 823, 827, 839, 859, 863, 883, 887, 907, 
                  911, 919, 947, 967, 971, 983, 991, 1019, 1031, 1039, 1051, 1063, 
                  1087, 1091, 1103, 1123, 1151, 1163, 1171, 1187, 1223, 1231, 1259, 
                  1279, 1283, 1291, 1303, 1307, 1319, 1327, 1367, 1399, 1423, 1427, 
                  1439, 1447, 1451, 1459, 1471, 1483, 1487, 1499, 1511, 1523, 1531, 
                  1543, 1559, 1567, 1571, 1579, 1583, 1607, 1619, 1627, 1663, 1667, 
                  1699, 1723, 1747, 1759, 1783, 1787, 1811, 1823, 1831, 1847, 1867, 
                  1871, 1879, 1907, 1931, 1951, 1979, 1987, 1999, 2003, 2011, 2027, 
                  2039, 2063, 2083, 2087, 2099, 2111, 2131, 2143, 2179, 2203, 2207, 
                  2239, 2243, 2251, 2267, 2287, 2311, 2339, 2347, 2351, 2371, 2383, 
                  2399, 2411, 2423, 2447, 2459, 2467, 2503, 2531, 2539, 2543, 2551, 
                  2579, 2591, 2647, 2659, 2663, 2671, 2683, 2687, 2699, 2707, 2711, 
                  2719, 2731, 2767, 2791, 2803, 2819, 2843, 2851, 2879, 2887, 2903, 
                  2927, 2939, 2963, 2971, 2999, 3011, 3019, 3023, 3067, 3079, 3083, 
                  3119, 3163, 3167, 3187, 3191, 3203, 3251, 3259, 3271, 3299, 3307, 
                  3319, 3323, 3331, 3343, 3347, 3359, 3371, 3391, 3407, 3463, 3467, 
                  3491, 3499, 3511, 3527, 3539, 3547, 3559, 3571, 3583, 3607, 3623, 
                  3631, 3643, 3659, 3671, 3691, 3719, 3727, 3739, 3767, 3779, 3803, 
                  3823, 3847, 3851, 3863, 3907, 3911, 3919, 3923, 3931, 3943, 3947, 
                  3967, 4003, 4007, 4019, 4027, 4051, 4079, 4091, 4099, 4111, 4127, 
                  4139, 4159, 4211, 4219, 4231, 4243, 4259, 4271, 4283, 4327, 4339, 
                  4363, 4391, 4423, 4447, 4451, 4463, 4483, 4507, 4519, 4523, 4547, 
                  4567, 4583, 4591, 4603, 4639, 4643, 4651, 4663, 4679, 4691, 4703, 
                  4723, 4751, 4759, 4783, 4787, 4799, 4831, 4871, 4903, 4919, 4931, 
                  4943, 4951, 4967, 4987, 4999, 5003, 5011, 5023, 5039, 5051, 5059, 
                  5087, 5099, 5107, 5119, 5147, 5167, 5171, 5179, 5227, 5231, 5279, 
                  5303, 5323, 5347, 5351, 5387, 5399, 5407, 5419, 5431, 5443, 5471, 
                  5479, 5483, 5503, 5507, 5519, 5527, 5531, 5563, 5591, 5623, 5639, 
                  5647, 5651, 5659, 5683, 5711, 5743, 5779, 5783, 5791, 5807, 5827, 
                  5839, 5843, 5851, 5867, 5879, 5903, 5923, 5927, 5939, 5987, 6007, 
                  6011, 6043, 6047, 6067, 6079, 6091, 6131, 6143, 6151, 6163, 6199, 
                  6203, 6211, 6247, 6263, 6271, 6287, 6299, 6311, 6323, 6343, 6359, 
                  6367, 6379, 6427, 6451, 6491, 6547, 6551, 6563, 6571, 6599, 6607, 
                  6619, 6659, 6679, 6691, 6703, 6719, 6763, 6779, 6791, 6803, 6823, 
                  6827, 6863, 6871, 6883, 6899, 6907, 6911, 6947, 6959, 6967, 6971, 
                  6983, 6991, 7019, 7027, 7039, 7043, 7079, 7103, 7127, 7151, 7159, 
                  7187, 7207, 7211, 7219, 7243, 7247, 7283, 7307, 7331, 7351, 7411, 
                  7451, 7459, 7487, 7499, 7507, 7523, 7547, 7559, 7583, 7591, 7603, 
                  7607, 7639, 7643, 7687, 7691, 7699, 7703, 7723, 7727, 7759, 7823, 
                  7867, 7879, 7883, 7907, 7919)
  
  
  if (is.null(prime)){
      nceil<-nn <-  n + 4 - (n %% 4)
      if ( (n %% 4) +4 ==  (n %% 8)) {
          while (!(nn %% 8)){ nn <- nn /2}
          if ((nn-1) %in% small.primes){
              m<-paley(prime=nn-1,check=check)
              while(nn<nceil){
                  m<-rbind(cbind(m,m),cbind(m,1-m))
                  nn<-nn*2
              }
              return(m)
          } 
      }
      
      if (n>max(small.primes)) return(NULL)
      p<-min(small.primes[small.primes>=n])
      if ((p+1 > nceil+4) && (nceil+4 < nmax)) return(paley(nceil+3))
      if (p>nmax) return(NULL)
  } else{ 
      p<-prime
      if ((p+1) %% 4 !=0) {
          warning("'prime'+1 is not divisible by 4")
          return(NULL)
      }
      if (p<n) {
          warning("'prime' is too small")
      return(NULL)
      }
  }

  m<-outer(0:(p-1) ,0:(p-1),"+") %% p
  
  res<-integer(1+floor((p-1)/2))
  res[1]<-0
  res[2]<-1
  for(i in 2:floor((p-1)/2))
    res[i+1]<- (i*i) %% p
  
  m[m %in% res]<-0
  m[m>0]<-1
  
  rval<-cbind(1,rbind(1,m))
  if(check) { 
    if(!is.hadamard(rval))
      warning("matrix is not Hadamard: is 'prime' really prime?")
  }
  rval
}


is.hadamard<-function(H, style=c("0/1","+-"), full.orthogonal.balance=TRUE){
    if (is.matrix(H) && is.numeric(H) && (ncol(H)==nrow(H))){
        H<-switch(match.arg(style),
                  "0/1"= 2*H-1, 
                  "+-"=H)        
        isTRUE(all.equal(crossprod(H), diag(ncol(H))*ncol(H))) &&
        all.equal(max(abs(H)),1) &&
        (!full.orthogonal.balance || sum(H[-1,])==0)
          
    } else FALSE
}
