% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{sd_reactive}
\alias{sd_reactive}
\title{Create a reactive value that is also stored in survey data}
\usage{
sd_reactive(id, expr, blank_na = TRUE)
}
\arguments{
\item{id}{Character string. The id (name) of the value to be stored in the data.}

\item{expr}{An expression that calculates a value based on inputs}

\item{blank_na}{Logical. If TRUE, NA values are converted to empty strings. Default is TRUE.}
}
\value{
A reactive expression that can be called like a function
}
\description{
This function creates a reactive value similar to Shiny's reactive() function,
but also automatically stores the calculated value in the survey data.
}
\examples{
\dontrun{
# In your server function:
product <- sd_reactive("product", {
  input$first_number * input$second_number
})

# Use the reactive value elsewhere
output$result <- renderText({
  paste("The product is:", product())
})

# In your survey.qmd file, display the value:
The product is: `r sd_output("product", type = "value")`.
}

}
