% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_subset_rate.R
\name{tab_subset_rate}
\alias{tab_subset_rate}
\title{Calculate rates for subsets}
\usage{
tab_subset_rate(
  vr,
  vrby,
  pop,
  lvls = c(),
  per = getOption("surveytable.rate_per"),
  drop_na = getOption("surveytable.drop_na"),
  max_levels = getOption("surveytable.max_levels"),
  csv = getOption("surveytable.csv")
)
}
\arguments{
\item{vr}{variable to tabulate}

\item{vrby}{use this variable to subset the survey}

\item{pop}{a \code{data.frame} with columns named \code{Level}, \code{Subset}, and \code{Population}. \code{Level} must
exactly match the levels of \code{vr}. \code{Subset} must exactly match the levels of
\code{vrby}. \code{Population} is the population for that level of \code{vr} and \code{vrby}.}

\item{lvls}{(optional) only show these levels of \code{vrby}}

\item{per}{calculate rate per this many items in the population}

\item{drop_na}{drop missing values (\code{NA})?}

\item{max_levels}{a categorical variable can have at most this many levels. Used to avoid printing huge tables.}

\item{csv}{name of a CSV file}
}
\value{
A list of tables or a single table.
}
\description{
Create subsets of the survey using one variable, and tabulate
the rates of another variable within each of the subsets.
}
\examples{
set_survey(namcs2019sv)
tab_subset_rate("AGER", "SEX", uspop2019$`AGER x SEX`)
}
\seealso{
Other tables: 
\code{\link{tab_cross}()},
\code{\link{tab_rate}()},
\code{\link{tab}()},
\code{\link{total_rate}()},
\code{\link{total}()}
}
\concept{tables}
