% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkContSig.R
\name{checkContSig}
\alias{checkContSig}
\title{Calculate association between survival and a continuous measure#' @inheritParams allPvals}
\usage{
checkContSig(measure, time, event)
}
\arguments{
\item{measure}{A continuous variable used to order survival data. Samples
must be ordered exactly as in time and event}

\item{time}{A numeric vector of sample time-to-event data, ordered exactly as 
measure. Must not contain NAs}

\item{event}{A vector of sample event data, ordered exactly as measure. Must not 
contain NAs}
}
\value{
p-value of association between measure and survival
}
\description{
Calculate association between survival and a continuous measure#' @inheritParams allPvals
}
\examples{
library(survivALL)
library(Biobase)
data(nki_subset)

#Calculate p-value for continuous measure SCUBE2
srv_dfr <- data.frame(measure = exprs(nki_subset)["NM_020974", ],
                      time = nki_subset$t.dmfs,
                      event = nki_subset$e.dmfs
                      )

checkContSig(srv_dfr$measure, srv_dfr$time, srv_dfr$event)
}
