% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{challenge_description}
\alias{challenge_description}
\title{Challenge Description}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{version}}{Country code for the version of the show}
  \item{\code{version_season}}{Version season key}
  \item{\code{season_name}}{The season name}
  \item{\code{season}}{The season number}
  \item{\code{episode}}{Episode number}
  \item{\code{challenge_id}}{Primary key}
  \item{\code{challenge_number}}{}
  \item{\code{challenge_type}}{}
  \item{\code{name}}{The name of the challenge}
  \item{\code{recurring_name}}{Challenges can go by different names but are often associated with a particular challenge or element
  of a challenge. Some challenges use combinations of other challenges so it's not perfect but consistent with the wiki page.
  Use \code{recurring_name} to analyse how often a challenge has been run.}
  \item{\code{description}}{Description of the challenge}
  \item{\code{reward}}{Description of the reward}
  \item{\code{additional_stipulation}}{Some challenges come with various rules or success criteria. This states those conditions.}
  \item{\code{race}}{If the challenge is a race between tribes, teams or individuals}
  \item{\code{endurance}}{If the challenge is an endurance event e.g. last tribe, team, individual standing}
  \item{\code{turn_based}}{If the challenge is turn bases i.e. conducted in rounds}
  \item{\code{puzzle}}{If the challenge contains a puzzle element}
  \item{\code{precision}}{If the challenge contains a precision element e.g. shooting an arrow, hitting a target, etc}
  \item{\code{strength}}{If the challenge has a strength based}
  \item{\code{balance}}{If the challenge contains a balancing element. My refer to the player balancing on something or
  the player balancing an object on something e.g. The Ball Drop}
  \item{\code{food}}{If the challenge contains a food element e.g. the food challenge, biting off chunks of meat}
  \item{\code{knowledge}}{If the challenge contains a knowledge component e.g. Q and A about the location}
  \item{\code{memory}}{If the challenge contains a memory element e.g. memorising a sequence of items}
  \item{\code{fire}}{If the challenge contains an element of fire making / maintaining}
  \item{\code{water}}{If the challenge is held, in part, in the water}
}
}
\source{
\url{https://survivor.fandom.com/wiki/Category:Challenges}
}
\usage{
challenge_description
}
\description{
A dataset detailing the challenges played and the elements they include over all seasons of Survivor
}
\details{
The features of each challenge have been determined largely through string searches of key words or phrases in the
challenge description. It may not capture the full essence of the challenge but on the whole will provide a good basis for
analysis.

Please log any suggested corrections at \url{https://github.com/doehm/survivoR}

For updated data please see the git version.
}
\examples{
library(dplyr)
library(tidyr)
challenge_description
}
\keyword{datasets}
