% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_class.R
\name{s_factory}
\alias{s_factory}
\title{Factory of objects of class SURVIVAL}
\usage{
s_factory(s_family, ...)
}
\arguments{
\item{s_family}{a factory for a specific distribution}

\item{...}{parameters to define the survival distribution}
}
\value{
a SURVIVAL object
}
\description{
Create objects of the class SURVIVAL
}
\details{
The objects of the class SURVIVAL define different distributions of
survival times. Each class has its own set of parameters but once the
SURVIVAL object is defined, they have access to the same functions to
calculate:
\itemize{
\item survival time function: \code{sfx()},
\item hazard time function: \code{hfx()},
\item cumulative hazard function: \code{Cum_Hfx()}
\item the inverse of the cumulative hazard function: \code{invCum_Hfx()}.
\item generate random survival times: \code{rsurv()}
\item generate random survival times under proportional hazard ratio: \code{rsurvhr()}.
}

There several functions to plot the distributions
\itemize{
\item generic S3:  \code{plot.SURVIVAL()}
\item \code{plot_survival()}: to plot the functions
\item \code{ggplot_survival_random()}: to ggplot random draws from the distribution
\item \code{compare_survival()}:  to compare the functions of two SURVIVAL objects
}
}
\section{Distributions}{

The current factories are implemented:
\itemize{
\item \code{s_exponential()}: for Exponential distributions
\item \code{s_weibull()}: for Weibull distributions
\item \code{s_gompertz()}: for Gompertz distributions
\item \code{s_picewise()}: for Piecewise exponential distributions
}
}

\examples{
# Define a SURVIVAL object
obj <- s_factory(s_exponential, lambda = 2)

# Survival, Hazard and Cumulative hazard at time 0.4
sfx(SURVIVAL = obj, t= 0.4)
hfx(SURVIVAL = obj, t = 0.4)
Cum_Hfx(SURVIVAL = obj, t = 0.4)

# Time when the Cumulative hazard is 0.8
invCum_Hfx(SURVIVAL = obj, H = 0.8)

# Draw one random survival time from the distribution
rsurv(SURVIVAL = obj, n = 1)

# Draw one random survival time from the distribution, with hazard ratio 0.5
rsurvhr(SURVIVAL = obj, hr = 0.5)

# Plot the survival functions
plot(obj)
}
