% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aftreg.R
\name{aftreg}
\alias{aftreg}
\title{Fitting Accelerated Failure Time Models}
\usage{
aftreg(
  formula,
  data,
  baseline = c("exponential", "weibull", "lognormal", "loglogistic"),
  ...
)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{data an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which function is called.}

\item{baseline}{the chosen baseline distribution; options currently available are: exponential, weibull, lognormal and loglogistic distributions.}

\item{...}{further arguments passed to other methods.}
}
\value{
aftreg returns an object of class "aftreg" containing the fitted model.
}
\description{
Function to fit accelerated failure time (AFT)  models.
}
\examples{
\donttest{
library(survstan)
fit <- aftreg(Surv(futime, fustat) ~ ecog.ps + rx, data = ovarian, baseline = "weibull", init = 0)
summary(fit)
}

}
