% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggprentice.R
\name{ggprentice}
\alias{ggprentice}
\alias{dggprentice}
\alias{pggprentice}
\alias{qggprentice}
\alias{rggprentice}
\title{The Generalized Gamma Distribution (Prentice's alternative parametrization)}
\usage{
dggprentice(x, mu, sigma, varphi, log = FALSE)

pggprentice(q, mu = 0, sigma = 1, varphi, lower.tail = TRUE, log.p = FALSE)

qggprentice(p, mu = 0, sigma = 1, varphi, lower.tail = TRUE, log.p = FALSE)

rggprentice(n, mu = 0, sigma = 1, varphi, ...)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{mu}{location parameter of the distribution.}

\item{sigma}{scale parameter of the distribution (sigma > 0).}

\item{varphi}{shape parameter of the distribution.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}; otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}

\item{...}{further arguments passed to other methods.}
}
\value{
dggprentice gives the (log) probability function, pggprentice gives the (log) distribution function, qggprentice gives the quantile function, and rggprentice generates random deviates.
}
\description{
Probability function, distribution function, quantile function and random generation for the  distribution with parameters mu, sigma and varphi.
}
\details{
Probability density function:
\deqn{
f(x | \mu, \sigma, \varphi) =
\begin{cases}
\frac{|\varphi|(\varphi^{-2})^{\varphi^{-2}}}{\sigma x\Gamma(\varphi^{-2})}\exp\{\varphi^{-2}[\varphi w - \exp(\varphi w)]\}I_{[0, \infty)}(x), & \varphi \neq 0 \\
\frac{1}{\sqrt{2\pi}x\sigma}\exp\left\{-\frac{1}{2}\left(\frac{log(x)-\mu}{\sigma}\right)^2\right\}I_{[0, \infty)}(x), & \varphi = 0
\end{cases}
 }
where \eqn{w = \frac{\log(x) - \mu}{\sigma}}, for \eqn{-\infty < \mu < \infty}, \eqn{\sigma>0} and \eqn{-\infty < \varphi < \infty}.

Distribution function:
\deqn{
F(x|\mu, \sigma, \varphi) =
 \begin{cases}
F_{G}(y|1/\varphi^2, 1), & \varphi > 0 \\
1-F_{G}(y|1/\varphi^2, 1), & \varphi < 0 \\
F_{LN}(x|\mu, \sigma), & \varphi = 0
\end{cases}
}
where \eqn{y = \displaystyle\left(\frac{x}{\sigma}\right)^\varphi},
\eqn{F_{G}(\cdot|\nu, 1)} is the distribution function of
a gamma distribution with shape parameter \eqn{1/\varphi^2} and scale
parameter equals to 1, and \eqn{F_{LN}(x|\mu, \sigma)} corresponds to the
distribution function of a lognormal distribution with location parameter
\eqn{\mu} and scale parameter \eqn{\sigma}.
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
