% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_breakdown.R
\name{prediction_breakdown}
\alias{prediction_breakdown}
\title{BreakDown for survival models}
\usage{
prediction_breakdown(explainer, observation, time = NULL, prob = NULL,
  ...)
}
\arguments{
\item{explainer}{an object of the class 'surv_explainer'}

\item{observation}{a new observation to explain}

\item{time}{a time point at which variable contributions are computed. If NULL median time is taken.}

\item{prob}{a survival probability at which variable contributions are computed}

\item{...}{other parameters}
}
\value{
An object of class surv_prediction_breakdown_explainer
}
\description{
Function \code{surv_breakdown} is an extension of a broken function from breakDown package. It computes the contribution in prediction for the variables in the model.
The contribution is defined as the difference between survival probabilities for model with added specific value of variable and with the random levels of this variable.
}
\examples{
\donttest{
library(survxai)
library(rms)
data("pbcTest")
data("pbcTrain")
predict_times <- function(model, data, times){
                  prob <- rms::survest(model, data, times = times)$surv
                  return(prob)
                  }
cph_model <- cph(Surv(years, status)~., data=pbcTrain, surv=TRUE, x = TRUE, y=TRUE)
surve_cph <- explain(model = cph_model, data = pbcTest[,-c(1,5)], 
                    y = Surv(pbcTest$years, pbcTest$status), predict_function = predict_times)
broken_prediction <- prediction_breakdown(surve_cph, pbcTest[1,-c(1,5)])
}
}
