% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.epspath.R
\name{plot.epspath}
\alias{plot.epspath}
\title{plot the epspath, solution paths of SVR as a function of epsilon}
\usage{
\method{plot}{epspath}(x, intercept = FALSE, ...)
}
\arguments{
\item{x}{The epspath object}

\item{intercept}{if it is \code{TRUE}, then provides a intercept path plot.}

\item{...}{Generic compatibility}
}
\value{
The entire solution path of SVR solution as a function of \code{epsilon}.
}
\description{
produces a plot of the SVR \code{epsilon} path.
}
\examples{
set.seed(1)
n <- 30
p <- 50

x <- matrix(rnorm(n*p), n, p)
e <- rnorm(n, 0, 1)
beta <- c(1, 1, rep(0, p-2))
y <- x \%*\% beta + e
lambda <- 1
eobj <- epspath(x, y, lambda = lambda)
plot(eobj)

}
\author{
Dohyun Kim, Seung Jun Shin
}
