% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.svrpath.R
\name{plot.svrpath}
\alias{plot.svrpath}
\title{plot the svrpath, solution paths of SVR as a function of lambda}
\usage{
\method{plot}{svrpath}(x, intercept = FALSE, ...)
}
\arguments{
\item{x}{The svrpath object}

\item{intercept}{if it is \code{TRUE}, then provides a intercept path plot.}

\item{...}{Generic compatibility}
}
\value{
The entire solution path of SVR solution as a function of \code{lambda}.
}
\description{
produces a plot of the SVR \code{lambda} path.
}
\examples{
set.seed(1)
n <- 30
p <- 50

x <- matrix(rnorm(n*p), n, p)
e <- rnorm(n, 0, 1)
beta <- c(1, 1, rep(0, p-2))
y <- x \%*\% beta + e
svr.eps <- 1
obj <- svrpath(x, y, svr.eps = svr.eps)
plot(obj)
}
\author{
Dohyun Kim, Seung Jun Shin
}
