% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cd_plot}
\alias{cd_plot}
\title{Plotting a Cumulative Distribution}
\usage{
cd_plot(x, inc = 0.01, col = "darkgrey", cex = 1, font = 1,
  family = "", srt = -45, pch = 20, pcol = "black", pbg = "white",
  pcex = cex, lcol = col, lwd = 1, lty = 1, xlim = NULL,
  ylim = NULL, xlab = NULL, ylab = NULL, main = NULL, sub = NULL)
}
\arguments{
\item{x}{A numeric vector.}

\item{inc}{The (numeric) increment for constructing the sequence from 0 to \code{ceiling(max(x))}, plotted on the horizontal axis.}

\item{col}{The color of the line and the text labels: see \code{\link[grDevices]{colors}}.}

\item{cex}{The character expansion factor: a numberic value to specify the size of the text labels.}

\item{font}{The font of the text labels: \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic.}

\item{family}{The font family of the text labels: \code{"serif"}, \code{"sans"}, \code{"mono"}, or one of the \code{\link[grDevices]{Hershey}} fonts.}

\item{srt}{The rotation angle (in degrees) of the text labels.}

\item{pch}{The plotting character for displaying points: see \code{\link[graphics]{points}}.}

\item{pcol}{The color of the plotting character: see \code{\link[grDevices]{colors}}.}

\item{pbg}{The background color of the plotting character: see \code{\link[grDevices]{colors}}.}

\item{pcex}{The character expansion factor of the plotting character: a numeric value to specify the size of the plotting character.}

\item{lcol}{The color of the line: see \code{\link[grDevices]{colors}}.}

\item{lwd}{The line width of the line: a numeric value to specify the width of the line.}

\item{lty}{The line type of the line: \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"}, \code{3} or
\code{"dotted"}, \code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}.}

\item{xlim}{A vector of two numeric values specifying the lower and upper limit between which to plot the horizontal axis.}

\item{ylim}{A vector of two numeric values specifying the lower and upper limit between which to plot the vertical axis.}

\item{xlab}{A character string for labelling of the horizontal axis.}

\item{ylab}{A character string for labelling of the vertical axis.}

\item{main}{A character string for the main title of the plot.}

\item{sub}{A character string for the subtitle of the plot.}
}
\value{
A cumulative distribution plot.
}
\description{
A function for plotting a cumulative distribution.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\\t", quote = "\\"", encoding = "UTF-8")
sca.SndT_Fra <- fast_sca(SndT_Fra)
dis.SndT_Fra <- dist_wrt(sca.SndT_Fra$pos1)
cd_plot(dis.SndT_Fra)
}

