S1 <- c("math", "algebra", "geometry", "calculus", "equations", "computation", "numbers", "addition")
T1 <- c("poetry", "art", "dance", "literature", "novel", "symphony", "drama", "sculpture")
A1 <- c("male", "man", "boy", "brother", "he", "him", "his", "son")
B1 <- c("female", "woman", "girl", "sister", "she", "her", "hers", "daughter")

test_that(".guess errors and integration with query", {
    expect_error(.guess())
    expect_error(.guess(w = googlenews))
    expect_error(.guess(w = googlenews, S_words = S1))
    expect_error(.guess(w = googlenews, S_words = S1, T_words = T1))
    expect_error(.guess(w = googlenews, A_words = A1))
    expect_error(.guess(w = googlenews, S_words = S1, B_words = B1))
    expect_error(.guess(w = googlenews, B_words = B1))
    expect_error(.guess(w = googlenews, T_words = T1))
    expect_error(.guess(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1, method = "whatever"))
    expect_error(query())
    expect_error(query(w = googlenews))
    expect_error(query(w = googlenews, S_words = S1))
    expect_error(query(w = googlenews, S_words = S1, T_words = T1))
    expect_error(query(w = googlenews, A_words = A1))
    expect_error(query(w = googlenews, S_words = S1, B_words = B1))
    expect_error(query(w = googlenews, B_words = B1))
    expect_error(query(w = googlenews, T_words = T1))
    expect_error(query(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1, method = "whatever"))
})

test_that("guessing and integration with query", {
    expect_equal("mac", .guess(w = googlenews, S_words = S1, A_words = A1))
    expect_equal("mac", .guess(w = googlenews, S_words = S1, A_words = A1, method = "mac"))
    expect_equal("rnd", .guess(w = googlenews, S_words = S1, A_words = A1, B_words = B1))
    expect_equal("rnd", .guess(w = googlenews, S_words = S1, A_words = A1, B_words = B1, method = "rnd"))
    expect_output(.guess(w = googlenews, S_words = S1, A_words = A1, B_words = B1, verbose = TRUE))
    expect_equal("semaxis", .guess(w = googlenews, S_words = S1, A_words = A1, B_words = B1, method = "semaxis"))
    expect_equal("weat", .guess(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1))
    expect_equal("weat", .guess(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1, method = "weat"))
    expect_equal("rnd", .guess(w = googlenews, S_words = S1, T_words = T, A_words = A1, B_words = B1, method = "rnd"))
    expect_equal("rnsb", .guess(w = googlenews, S_words = S1, T_words = T, A_words = A1, B_words = B1, method = "rnsb"))
    expect_equal("ect", .guess(w = googlenews, S_words = S1, T_words = T, A_words = A1, B_words = B1, method = "ect"))
    expect_equal("nas", .guess(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1, method = "nas"))
    expect_true("mac" %in% class(query(w = googlenews, S_words = S1, A_words = A1)))
    expect_true("mac" %in% class(query(w = googlenews, S_words = S1, A_words = A1, method = "mac")))
    expect_true("rnd" %in% class(query(w = googlenews, S_words = S1, A_words = A1, B_words = B1)))
    expect_true("rnd" %in% class(query(w = googlenews, S_words = S1, A_words = A1, B_words = B1, method = "rnd")))
    expect_true("ect" %in% class(query(w = googlenews, S_words = S1, A_words = A1, B_words = B1, method = "ect")))
    expect_output(query(w = googlenews, S_words = S1, A_words = A1, B_words = B1, verbose = TRUE))
    expect_true("semaxis" %in% class(query(w = googlenews, S_words = S1, A_words = A1, B_words = B1, method = "semaxis")))
    expect_true("weat" %in% class(query(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1)))
    expect_true("weat" %in% class(query(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1, method = "weat")))
    expect_true("rnd" %in% class(query(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1, method = "rnd")))
    expect_true("rnsb" %in% class(query(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1, method = "rnsb")))
    expect_true("nas" %in% class(query(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1, method = "nas")))
    expect_true("ect" %in% class(query(w = googlenews, S_words = S1, T_words = T1, A_words = A1, B_words = B1, method = "ect")))
})
