% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers_decomposed_ts.R
\name{tidiers_decomposed_ts}
\alias{tidiers_decomposed_ts}
\alias{sw_tidy_decomp.decomposed.ts}
\title{Tidying methods for decomposed time series}
\usage{
\method{sw_tidy_decomp}{decomposed.ts}(x, timetk_idx = FALSE, rename_index = "index", ...)
}
\arguments{
\item{x}{An object of class "decomposed.ts"}

\item{timetk_idx}{Used with \code{sw_augment} and \code{sw_tidy_decomp}.
When \code{TRUE}, uses a timetk index (irregular, typically date or datetime) if present.}

\item{rename_index}{Used with \code{sw_augment} and \code{sw_tidy_decomp}.
A string representing the name of the index generated.}

\item{...}{Not used.}
}
\value{
\strong{\code{sw_tidy_decomp()}} returns a tibble with the following time series attributes:
\itemize{
\item \code{index}: An index is either attempted to be extracted from the model or
a sequential index is created for plotting purposes
\item \code{season}: The seasonal component
\item \code{trend}: The trend component
\item \code{random}: The error component
\item \code{seasadj}: observed - season
}
}
\description{
Tidying methods for decomposed time series
}
\examples{
library(dplyr)
library(forecast)
library(sweep)

fit_decomposed <- USAccDeaths \%>\%
    decompose()

sw_tidy_decomp(fit_decomposed)

}
\seealso{
\code{\link[=decompose]{decompose()}}
}
