% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Section14}
\alias{Section14}
\alias{swe_house_pos}
\alias{swe_gauquelin_sector}
\title{Section 14: House position calculations}
\usage{
swe_house_pos(armc, geolat, eps, hsys, xpin)

swe_gauquelin_sector(
  jd_ut,
  ipl,
  starname,
  ephe_flag,
  imeth,
  geopos,
  atpress,
  attemp
)
}
\arguments{
\item{armc}{right ascension of the MC as double (deg)}

\item{geolat}{geographic latitude as double (deg)}

\item{eps}{ecliptic obliquity as double (deg)}

\item{hsys}{house method, one-letter case sensitive as char}

\item{xpin}{longitude and latitude of the given body as numeric vector (deg)}

\item{jd_ut}{UT Julian day number as double (day)}

\item{ipl}{Body/planet as integer (\code{SE$SUN=0}, \code{SE$MOON=1}, ... \code{SE$PLUTO=9})}

\item{starname}{Star name as string (\code{""} for no star)}

\item{ephe_flag}{Ephemeris flag as integer (\code{SE$FLG_JPLEPH=1}, \code{SE$FLG_SWIEPH=2} or \code{SE$FLG_MOSEPH=4})}

\item{imeth}{Gauquelin method as integer (0, 1, 2, 3, 4 or 5)}

\item{geopos}{position as numeric vector (longitude, latitude, height)}

\item{atpress}{Atmospheric pressure as double (hPa)}

\item{attemp}{Atmospheric temperature as double (Celsius)}
}
\value{
\code{swe_house_pos} returns a list with named entries: \code{return} how far from body's cusp as double,
     and \code{serr} error message as string.

\code{swe_gauquelin_sector} returns a list with named entries: \code{return} status flag as integer,
     \code{dgsect} for Gauquelin sector as double and \code{serr} error message as string
}
\description{
Calculate house position of a given body.
}
\details{
\describe{
\item{swe_house_pos()}{Calculate house position of given body.}
}

\describe{
\item{swe_gauquelin_sector()}{Compute the Gauquelin sector position of a planet or star. }
}
}
\examples{
swe_house_pos(12, 53, 23, 'B', c(0,0))
data(SE)
swe_gauquelin_sector(1234567.5,SE$VENUS,"",SE$FLG_MOSEPH,0,c(0,50,10),1013.25,15)
}
\seealso{
Section 14 in \url{http://www.astro.com/swisseph/swephprg.htm}. Remember that array indices start in R at 1, while in C they start at 0!
}
