% Generated by roxygen2 (4.0.1): do not edit by hand
\name{install_course_zip}
\alias{install_course_zip}
\title{Install a course from a zipped course folder}
\usage{
install_course_zip(path, multi = FALSE, which_course = NULL)
}
\arguments{
\item{path}{The path to the zipped course.}

\item{multi}{Set to \code{TRUE} if the zipped directory contains multiple courses. The default value is \code{FALSE}.}

\item{which_course}{A vector of course names. Only for use when zip file contains multiple courses, but you don't want to install all of them.}
}
\description{
Install a course from a zipped course folder
}
\examples{
\dontrun{

install_course_zip("~/Desktop/my_course.zip")

install_course_zip("~/Downloads/swirl_courses-master.zip", multi=TRUE,
                   which_course=c("R Programming", "Data Analysis"))
}
}
\seealso{
Other InstallCourses: \code{\link{InstallCourses}};
  \code{\link{install_course_directory}};
  \code{\link{install_course_dropbox}};
  \code{\link{install_course_github}};
  \code{\link{install_course_google_drive}};
  \code{\link{install_course_url}};
  \code{\link{install_from_swirl}};
  \code{\link{uninstall_course}}; \code{\link{zip_course}}
}

