% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wq.R
\name{wq_command}
\alias{wq_command}
\title{Template for R command question}
\usage{
wq_command(output = "explain what the user must do here",
  correct_answer = "EXPR or VAL",
  answer_tests = "omnitest(correctExpr='EXPR', correctVal=VAL)",
  hint = "hint")
}
\arguments{
\item{output}{Text that is displayed to the user.}

\item{correct_answer}{A string that designates the correct answer, in this
case an R expression or a value.}

\item{answer_tests}{An internal function from \code{swirl} for testing the 
user's choice. See \code{\link[swirl]{AnswerTests}}.}

\item{hint}{A string that is printed to the console if the user answers this
question incorrectly.}
}
\description{
Template for R command question
}
\examples{
\dontrun{
# While writing a new lesson by hand just use:
wq_command()

# If converting from another format to a swirl course you may want to sue the
# API:
wq_command("Assign the value 5 to the variable x.",
 "x <- 5", "omnitest(correctExpr='x <- 5')", "Just type: x <- 5")
}
}

