% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{benchmark}
\alias{benchmark}
\title{Benchmark or signal an event or achievement with a giant checkmark.}
\arguments{
\item{eavesdrop}{The variable to track.}

\item{benchmark}{The numerical value associated with \code{eavesdrop} that
will trigger a visual benchmark on a widget. For example, if \code{eavesdrop}
is a variable that ranges from 1 to 100, then \code{benchmark = 50} will flag
completion at the 50 value.}

\item{label}{A small caption/label for the widget.}

\item{size}{A number used to designate the size (magnification) of the
widget. The default is set to \code{1} which is 80 by 80 pixels. For
example, setting to \code{3} will results in a widget 3-times the default
size (240 by 240 pixels) and will occupy a grid area of 3 by 3.}

\item{placeOnGrid}{A row by column coordinate (e.g., \code{c(row-number, column-number)})
of a grid that designates the position to draw the widget on the
\code{switchboard}. Use \code{showGrid()} to help organize widget placement
on dashboard. The default places the first widget in pipe chain to
the \code{c(1, 1)} position, and all following on the same row stacked to
the right.}
}
\value{
Nothing.
}
\description{
The \code{benchmark} widget displays the number of simulation iterations.
}
\section{Usage}{

   \preformatted{benchmark(eavesdrop = NULL, benchmark = NA, label = "",
   size = 1, placeOnGrid = c(1, 1))}
}

\examples{
\dontrun{

   for (i in 1:250) {
     switchboard(delay = 0.01) \%>\%
       benchmark(i, benchmark = 125, label = ">125")
   }
   switchboard_close()

}

}
\seealso{
Other eavesdroppers: 
\code{\link{counter_tally}()},
\code{\link{counter}()},
\code{\link{eavesdropper_2D}()},
\code{\link{eavesdropper_X}()},
\code{\link{eavesdropper}()},
\code{\link{injector_2D}()},
\code{\link{injector_X}()},
\code{\link{injector}()},
\code{\link{number_pair}()},
\code{\link{number_quartet}()},
\code{\link{number_trio}()},
\code{\link{number}()},
\code{\link{progress_benchmark}()}
}
\concept{eavesdroppers}
