% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switchboard.R
\name{switchboard_engine}
\alias{switchboard_engine}
\title{Widget engine to construct/update/layout piped items on switchboard}
\usage{
switchboard_engine(
  .switchboard,
  eavesdrop = c(NULL, NULL),
  inject = c("", ""),
  minimum = c(" ", " "),
  maximum = c(" ", " "),
  label = c(" ", " "),
  size = 1,
  placeOnGrid = c(NULL, NULL),
  extendRow = 1,
  updates = 1,
  digits = 5,
  forget = 400,
  delay = 0,
  plotRegression = FALSE,
  plotSampleSize = FALSE,
  plotMean = FALSE,
  switch = FALSE,
  honest = TRUE,
  closeAtMaximum = FALSE,
  fill = "horizontal",
  file = "",
  benchmark = NA,
  constructor,
  updater
)
}
\arguments{
\item{.switchboard}{A parent switchboard window. It is defined when \code{layout}
is piped to a switchboard with \code{\%>\%}. If \code{layout} is called without a
parent \code{switchboard()}, it will create it's own internally. NOTE:
\code{switchboard} manages this parameter and you should not modify it.}

\item{eavesdrop}{The variable(s) to display or track within a widget.}

\item{inject}{Variable names(s) as strings of variables to be modified by widgets.}

\item{minimum}{The minimum value of \code{eavesdrop}.}

\item{maximum}{The maximum value of \code{eavesdrop}.}

\item{label}{The caption/label(s) of the widget.}

\item{size}{A number used to designate the size (magnification) of the
widget. The default is set to \code{1} which is 80 by 80 pixels. For
example, setting to \code{3} will results in a widget 3-times the default
size (240 by 240 pixels) and will occupy a grid area of 3 by 3.}

\item{placeOnGrid}{A row by column coordinate (e.g., \code{c(row-number, column-number)})
of a grid that designates the position to draw the widget on the
\code{switchboard}. Use \code{layout()} to help organize widget placement
on dashboard. The default places the first widget in pipe chain to
the \code{c(1, 1)} position, and all following on the same row stacked to
the right.}

\item{extendRow}{Extends the width of a widget and not the height. Used to better 
organize text within \code{caption} widget.}

\item{updates}{The number of times the widget is to be updated (e.g., when
it be modified/changed). The default updates the widget 100 times.}

\item{digits}{The number of digits to display in a widget.}

\item{forget}{A time-delay in millisecond for when displayed points on a
widget will be deleted.}

\item{delay}{Pause each update of the switchboard. Default has no delay,
values are in seconds (e.g., \code{delay = 0.01} results in 0.01 second
delay with each iteration).}

\item{plotRegression}{Display a switchboard-estimated regression line on a widget.}

\item{plotSampleSize}{Display the number items (N) displayed within a widget.}

\item{plotMean}{Display a switchboard-estimated mean and standard deviation
whisker plot on a widget.}

\item{switch}{Display an on/off switch on a widget that controls the
updating of the widget. When \code{TRUE} it will add the switch in the
off-state on the switchboard. The user must activate the switch to start
the widget.}

\item{honest}{When \code{TRUE}, it updates the widget by the true percentage.
 The default (\code{FALSE}) has a cosmetic modification to the percentage
value that helps update it in a prettier way.}

\item{closeAtMaximum}{Functions like \code{switchboard_close} by closing
the switchboard window when the eavesdropped value equals maximum. NOTE:
if a widget has \code{closeAtMaximum = TRUE}, then this widget MUST
be placed at the end (i.e., last widget) of the pipe chain.}

\item{fill}{The direction of how things are animated when displaying
progression. The default is \code{horizontal}, which tracks progression
from left to right, but \code{vertical} can also be used for progress to
occur in a bottom to up animation.}

\item{file}{A *.png filename with a transparent background that designates an
image to be used as a progress-bar. The total image size should be
80 by 80 pixels, but for best integration into switchboard layout, the
actual image must be 75 by 75 pixels placed at the bottom left of the
80 by 80 image. This will leave a 5 pixel whitespace at both the top
and right side of the image.}

\item{benchmark}{The numerical value that will trigger a visual benchmark
on a widget.}

\item{constructor}{A widget-specific function that contains the Tcl/Tk script to
build the widget.}

\item{updater}{A widget-specific function that contains the Tcl/Tk script to
update the constructed widget.}
}
\description{
Widget engine to construct/update/layout piped items on switchboard
}
\keyword{internal}
