/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.Const;
import dag.Dag;
import java.util.Arrays;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;

public final class LinkageEquilibriumDag
implements Dag {
    private final Markers markers;
    private final float[][] alleleFreq;
    private final byte maxAlleles;
    private final int sumAlleles;

    public LinkageEquilibriumDag(GL gL, float f) {
        if (f <= 0.0f || f >= 0.5f) {
            throw new IllegalArgumentException("minFreq: " + f);
        }
        int n = gL.nMarkers();
        byte by = 0;
        this.markers = gL.markers();
        this.alleleFreq = new float[n][];
        for (int i = 0; i < n; ++i) {
            this.alleleFreq[i] = LinkageEquilibriumDag.alleleFrequencies(gL, i, f);
            if (this.alleleFreq[i].length <= by) continue;
            by = (byte)this.alleleFreq[i].length;
        }
        this.maxAlleles = by;
        this.sumAlleles = gL.markers().sumAlleles();
    }

    private static float[] alleleFrequencies(GL gL, int n, float f) {
        int n2 = gL.nSamples();
        int n3 = gL.marker(n).nAlleles();
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        for (int i = 0; i < n2; ++i) {
            int n4;
            for (n4 = 0; n4 < n3; n4 = (int)((byte)(n4 + 1))) {
                for (int n5 = 0; n5 < n3; n5 = (int)((byte)(n5 + 1))) {
                    float f2 = gL.gl(n, i, (byte)n4, (byte)n5);
                    int n6 = n4;
                    fArray2[n6] = fArray2[n6] + f2;
                    int n7 = n5;
                    fArray2[n7] = fArray2[n7] + f2;
                }
            }
            LinkageEquilibriumDag.divideEntriesBySum(fArray2);
            for (n4 = 0; n4 < fArray2.length; ++n4) {
                int n8 = n4;
                fArray[n8] = fArray[n8] + fArray2[n4];
                fArray2[n4] = 0.0f;
            }
        }
        LinkageEquilibriumDag.divideEntriesBySum(fArray);
        LinkageEquilibriumDag.enforceMinFrequency(fArray, f);
        return fArray;
    }

    private static void divideEntriesBySum(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] / f;
        }
    }

    private static void enforceMinFrequency(float[] fArray, float f) {
        boolean bl = false;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            fArray[i] = f;
            bl = true;
        }
        if (bl) {
            LinkageEquilibriumDag.divideEntriesBySum(fArray);
        }
    }

    private void checkLevel(int n) {
        if (n < 0 || n >= this.alleleFreq.length) {
            throw new IllegalArgumentException("level: " + n);
        }
    }

    private void checkEdge(int n, int n2) {
        if (n2 < 0 || n2 >= this.alleleFreq[n].length) {
            throw new IndexOutOfBoundsException("edge: " + n2);
        }
    }

    private void checkParentNode(int n, int n2) {
        this.checkLevel(n);
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("node: " + n2);
        }
    }

    @Override
    public int nEdges(int n) {
        return this.alleleFreq[n].length;
    }

    @Override
    public int nParentNodes(int n) {
        this.checkLevel(n);
        return 1;
    }

    @Override
    public int nChildNodes(int n) {
        this.checkLevel(n);
        return 1;
    }

    @Override
    public int parentNode(int n, int n2) {
        this.checkEdge(n, n2);
        return 0;
    }

    @Override
    public int childNode(int n, int n2) {
        this.checkEdge(n, n2);
        return 0;
    }

    @Override
    public byte symbol(int n, int n2) {
        this.checkEdge(n, n2);
        return (byte)n2;
    }

    @Override
    public float edgeCnt(int n, int n2) {
        return this.alleleFreq[n][n2];
    }

    @Override
    public float nodeCnt(int n, int n2) {
        this.checkParentNode(n, n2);
        return 1.0f;
    }

    @Override
    public float condEdgeProb(int n, int n2) {
        return this.alleleFreq[n][n2];
    }

    @Override
    public float edgeProb(int n, int n2) {
        return this.alleleFreq[n][n2];
    }

    @Override
    public float nodeProb(int n, int n2) {
        this.checkParentNode(n, n2);
        return 1.0f;
    }

    @Override
    public int nMarkers() {
        return this.alleleFreq.length;
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public long nNodes() {
        return this.alleleFreq.length + 1;
    }

    @Override
    public long nEdges() {
        return this.sumAlleles;
    }

    @Override
    public int maxNodes() {
        return 1;
    }

    @Override
    public int maxEdges() {
        return this.maxAlleles;
    }

    @Override
    public int nOutEdges(int n, int n2) {
        return this.alleleFreq[n].length;
    }

    @Override
    public int outEdge(int n, int n2, int n3) {
        this.checkParentNode(n, n2);
        this.checkEdge(n, n3);
        return n3;
    }

    @Override
    public int outEdgeBySymbol(int n, int n2, byte by) {
        return by;
    }

    @Override
    public int nInEdges(int n, int n2) {
        this.checkLevel(n);
        return this.alleleFreq[n].length;
    }

    @Override
    public int inEdge(int n, int n2, int n3) {
        this.checkEdge(n, n3);
        if (n2 != 0) {
            throw new IllegalArgumentException("childNode: " + n2);
        }
        return n3;
    }

    @Override
    public boolean isChildOf(int n, int n2, int n3) {
        this.checkEdge(n, n2);
        this.checkEdge(n + 1, n3);
        return true;
    }

    @Override
    public double[] posArray() {
        double[] dArray = new double[this.alleleFreq.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.alleleFreq.length; ++j) {
                d += (double)(this.alleleFreq[i][j] * this.alleleFreq[i][j]);
            }
            dArray[i] = i == 0 ? -Math.log10(d) : dArray[i - 1] - Math.log10(d);
        }
        return dArray;
    }

    @Override
    public String toString(int n, int n2) {
        if (n < 0 || n > n2 || n2 >= this.alleleFreq.length) {
            String string = "start=" + n + " end=" + n2;
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder((n2 - n) * 20);
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(Arrays.toString(this.alleleFreq[i]));
            stringBuilder.append(Const.nl);
        }
        return stringBuilder.toString();
    }
}

