/*
 * Decompiled with CFR 0.152.
 */
package ibd;

import haplotype.SampleHapPairs;
import vcf.Marker;

public class Haplotype {
    private final int start;
    private final int end;
    private final SampleHapPairs haps;
    private final int hapIndex;

    public Haplotype(SampleHapPairs sampleHapPairs, int n) {
        this(sampleHapPairs, n, 0, sampleHapPairs.nMarkers());
    }

    public Haplotype(SampleHapPairs sampleHapPairs, int n, int n2, int n3) {
        if (n2 < 0 || n2 > n3 || n3 > sampleHapPairs.nMarkers()) {
            String string = "start=" + n2 + " end=" + n3 + " haps.nMarkers()=" + sampleHapPairs.nMarkers();
            throw new IndexOutOfBoundsException(string);
        }
        if (n < 0 || n >= sampleHapPairs.nHaps()) {
            throw new IllegalArgumentException("hapIndex=" + n);
        }
        this.start = n2;
        this.end = n3;
        this.haps = sampleHapPairs;
        this.hapIndex = n;
    }

    public Haplotype restrict(int n, int n2) {
        if (n < 0 || n > n2 || n2 > this.length()) {
            String string = "start=" + n + " end=" + n2 + " this.length()=" + this.length();
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = this.start + n;
        int n4 = this.start + n2;
        return new Haplotype(this.haps, this.hapIndex, n3, n4);
    }

    public int length() {
        return this.end - this.start;
    }

    public int hapIndex() {
        return this.hapIndex;
    }

    public Marker marker(int n) {
        int n2 = this.start + n;
        if (n2 < this.start || n2 >= this.end) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.haps.marker(n2);
    }

    public byte allele(int n) {
        int n2 = this.start + n;
        if (n2 < this.start || n2 >= this.end) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.haps.allele(n2, this.hapIndex);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Haplotype haplotype = (Haplotype)object;
        int n = this.length();
        if (n != haplotype.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.allele(i) == haplotype.allele(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        for (int i = this.start; i < this.end; ++i) {
            n += 29 * n + this.haps.allele(i, this.hapIndex);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(3 * (this.end - this.start));
        stringBuilder.append('[');
        if (this.end > this.start) {
            stringBuilder.append(this.allele(0));
        }
        int n = this.end - this.start;
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(this.allele(i));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

