/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.Const;
import dag.DagLevel;
import dag.DagUtils;
import dag.ImmutableDagLevel;
import haplotype.HapsMarker;
import java.util.Arrays;
import vcf.Marker;

public class MergeableDagLevel {
    private MergeableDagLevel nextLevel = null;
    private MergeableDagLevel prevLevel = null;
    private final Marker marker;
    private final int markerIndex;
    private final int nAlleles;
    private final int nHaps;
    private int[][] outEdges;
    private int[] child2FirstInEdge;
    private int[] inEdge2NextInEdge;
    private int[] parentNodes;
    private int[] childNodes;
    private byte[] symbols;
    private float[] counts;
    private int[] child2FirstHap;
    private int[] hap2NextHap;

    public MergeableDagLevel(HapsMarker hapsMarker, float[] fArray) {
        this.checkParameters(hapsMarker, fArray);
        boolean bl = true;
        this.prevLevel = null;
        this.nextLevel = null;
        this.marker = hapsMarker.marker();
        this.markerIndex = 0;
        this.nAlleles = hapsMarker.marker().nAlleles();
        this.nHaps = hapsMarker.nHaps();
        this.allocateAndInitializeArrays(bl, this.nAlleles, this.nHaps);
        this.fillArrays(hapsMarker, fArray);
    }

    public MergeableDagLevel(MergeableDagLevel mergeableDagLevel, HapsMarker hapsMarker, float[] fArray) {
        this.checkParameters(mergeableDagLevel, hapsMarker, fArray);
        boolean bl = false;
        this.prevLevel = mergeableDagLevel;
        this.nextLevel = null;
        this.marker = hapsMarker.marker();
        this.markerIndex = mergeableDagLevel.markerIndex() + 1;
        this.nAlleles = hapsMarker.marker().nAlleles();
        this.nHaps = hapsMarker.nHaps();
        this.allocateAndInitializeArrays(bl, this.nAlleles, this.nHaps);
        this.fillArrays(mergeableDagLevel, hapsMarker, fArray);
    }

    private void checkParameters(HapsMarker hapsMarker, float[] fArray) {
        if (fArray.length != hapsMarker.nHaps()) {
            String string = "data.nHaps()=" + hapsMarker.nHaps() + " != weights.length=" + fArray.length;
            throw new IllegalArgumentException(string);
        }
    }

    private void checkParameters(MergeableDagLevel mergeableDagLevel, HapsMarker hapsMarker, float[] fArray) {
        this.checkParameters(hapsMarker, fArray);
        if (mergeableDagLevel.nextLevel != null) {
            throw new IllegalArgumentException("parent.nextLevel!=null");
        }
        if (mergeableDagLevel.nHaps() != hapsMarker.nHaps()) {
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private void allocateAndInitializeArrays(boolean bl, int n, int n2) {
        int n3 = bl ? n : n2;
        this.outEdges = new int[n][n3];
        this.child2FirstInEdge = new int[n3];
        this.inEdge2NextInEdge = new int[n3];
        this.parentNodes = new int[n3];
        this.childNodes = new int[n3];
        this.symbols = new byte[n3];
        this.counts = new float[n3];
        this.child2FirstHap = new int[n2];
        this.hap2NextHap = new int[n2];
        for (int[] nArray : this.outEdges) {
            Arrays.fill(nArray, -1);
        }
        Arrays.fill(this.child2FirstInEdge, -1);
        Arrays.fill(this.inEdge2NextInEdge, -1);
        Arrays.fill(this.parentNodes, -1);
        Arrays.fill(this.childNodes, -1);
        Arrays.fill(this.symbols, (byte)-1);
        Arrays.fill(this.child2FirstHap, -1);
        Arrays.fill(this.hap2NextHap, -1);
    }

    private void fillArrays(HapsMarker hapsMarker, float[] fArray) {
        int n = 0;
        int n2 = hapsMarker.nHaps();
        for (int i = 0; i < n2; ++i) {
            byte by = hapsMarker.allele(i);
            float f = fArray[i];
            int n3 = this.outEdges[by][n];
            if (n3 == -1) {
                n3 = by;
                this.addEdge(n, by, f, n3, i);
                continue;
            }
            assert (n3 == by);
            assert (n3 == this.childNodes[n3]);
            int n4 = this.childNodes[n3];
            int n5 = n3;
            this.counts[n5] = this.counts[n5] + f;
            this.hap2NextHap[i] = this.child2FirstHap[n4];
            this.child2FirstHap[n4] = i;
        }
    }

    private void fillArrays(MergeableDagLevel mergeableDagLevel, HapsMarker hapsMarker, float[] fArray) {
        int n = 0;
        int n2 = mergeableDagLevel.child2FirstHap.length;
        for (int i = 0; i < n2; ++i) {
            if (mergeableDagLevel.child2FirstHap[i] < 0) continue;
            int n3 = mergeableDagLevel.child2FirstHap[i];
            while (n3 != -1) {
                byte by = hapsMarker.allele(n3);
                float f = fArray[n3];
                int n4 = this.outEdges[by][i];
                if (n4 == -1) {
                    this.addEdge(i, by, f, n++, n3);
                } else {
                    assert (n4 == this.childNodes[n4]);
                    int n5 = this.childNodes[n4];
                    int n6 = n4;
                    this.counts[n6] = this.counts[n6] + f;
                    this.hap2NextHap[n3] = this.child2FirstHap[n5];
                    this.child2FirstHap[n5] = n3;
                }
                n3 = mergeableDagLevel.hap2NextHap[n3];
            }
        }
        if ((double)n < 0.75 * (double)this.nHaps) {
            this.reduceEdgeArrayLengths(n);
        }
        mergeableDagLevel.removeHaplotypeIndices();
    }

    private void addEdge(int n, byte by, float f, int n2, int n3) {
        int n4 = n2;
        this.outEdges[by][n] = n2;
        this.child2FirstInEdge[n4] = n2;
        this.parentNodes[n2] = n;
        this.childNodes[n2] = n4;
        this.symbols[n2] = by;
        this.counts[n2] = f;
        this.child2FirstHap[n4] = n3;
    }

    private void reduceEdgeArrayLengths(int n) {
        this.child2FirstInEdge = Arrays.copyOf(this.child2FirstInEdge, n);
        this.inEdge2NextInEdge = Arrays.copyOf(this.inEdge2NextInEdge, n);
        this.parentNodes = Arrays.copyOf(this.parentNodes, n);
        this.childNodes = Arrays.copyOf(this.childNodes, n);
        this.symbols = Arrays.copyOf(this.symbols, n);
        this.counts = Arrays.copyOf(this.counts, n);
    }

    private void removeHaplotypeIndices() {
        this.child2FirstHap = null;
        this.hap2NextHap = null;
    }

    public MergeableDagLevel setPreviousToNull() {
        MergeableDagLevel mergeableDagLevel = this.prevLevel;
        this.prevLevel = null;
        return mergeableDagLevel;
    }

    public void setNextLevel(MergeableDagLevel mergeableDagLevel) {
        if (mergeableDagLevel.prevLevel != this) {
            throw new IllegalArgumentException("nextLevel.previousLevel!=this");
        }
        this.nextLevel = mergeableDagLevel;
    }

    public MergeableDagLevel previous() {
        return this.prevLevel;
    }

    public MergeableDagLevel next() {
        return this.nextLevel;
    }

    public boolean hasSibling(int n) {
        int n2 = this.prevLevel.child2FirstInEdge[n];
        while (n2 >= 0) {
            int n3 = this.prevLevel.parentNodes[n2];
            int n4 = 0;
            int n5 = this.prevLevel.nAlleles;
            for (int i = 0; i < n5; ++i) {
                if (this.prevLevel.outEdges[i][n3] < 0) continue;
                ++n4;
            }
            if (n4 > 1) {
                return true;
            }
            n2 = this.prevLevel.inEdge2NextInEdge[n2];
        }
        return false;
    }

    public DagLevel toDagLevel() {
        char[] cArray = MergeableDagLevel.rankValues(DagUtils.removeValues(this.parentNodes, -1));
        char[] cArray2 = MergeableDagLevel.rankValues(DagUtils.removeValues(this.childNodes, -1));
        byte[] byArray = DagUtils.removeValues(this.symbols, (byte)-1);
        float[] fArray = DagUtils.removeValues(this.counts, 0.0f);
        return new ImmutableDagLevel(this.marker, cArray, cArray2, byArray, fArray);
    }

    private static char[] rankValues(int[] nArray) {
        int n;
        if (nArray.length == 0) {
            throw new IllegalArgumentException("array.length==0");
        }
        assert (nArray.length < 65535);
        int[] nArray2 = (int[])nArray.clone();
        Arrays.sort(nArray2);
        if (nArray2[0] < 0) {
            String string = "element<0: " + nArray2[0];
            throw new IllegalArgumentException(string);
        }
        int n2 = nArray2[nArray2.length - 1] + 1;
        char[] cArray = new char[n2];
        Arrays.fill(cArray, '\uffff');
        int n3 = n = 0;
        n = (char)(n + 1);
        cArray[nArray2[0]] = n3;
        for (int i = 1; i < nArray2.length; ++i) {
            if (nArray2[i] == nArray2[i - 1]) continue;
            int n4 = n;
            n = (char)(n + 1);
            cArray[nArray2[i]] = n4;
        }
        char[] cArray2 = new char[nArray.length];
        for (int i = 0; i < cArray2.length; ++i) {
            cArray2[i] = cArray[nArray[i]];
        }
        return cArray2;
    }

    public void mergeParentNodes(int n, int n2) {
        if (!this.isParentNode(n)) {
            String string = "invalid parent node: " + n;
            throw new IllegalArgumentException(string);
        }
        if (!this.isParentNode(n2)) {
            String string = "invalid parent node: " + n2;
            throw new IllegalArgumentException(string);
        }
        this.prevLevel.mergeChildNodes(n, n2);
        this.mergeParentNodes2(n, n2);
    }

    private void mergeParentNodes2(int n, int n2) {
        for (int n3 = 0; n3 < this.nAlleles; n3 = (int)((byte)(n3 + 1))) {
            int n4 = this.outEdges[n3][n];
            int n5 = this.outEdges[n3][n2];
            if (n5 < 0) continue;
            if (n4 == -1) {
                this.changeParent(n5, n);
                continue;
            }
            int n6 = this.childNode(n4);
            int n7 = this.childNode(n5);
            this.mergeEdges(n4, n5);
            if (this.nextLevel == null) continue;
            this.nextLevel.mergeParentNodes2(n6, n7);
        }
    }

    private void mergeChildNodes(int n, int n2) {
        int n3 = -1;
        int n4 = this.child2FirstInEdge[n2];
        while (n4 != -1) {
            assert (this.childNodes[n4] == n2);
            this.childNodes[n4] = n;
            n3 = n4;
            n4 = this.inEdge2NextInEdge[n4];
        }
        if (n3 != -1) {
            this.inEdge2NextInEdge[n3] = this.child2FirstInEdge[n];
            this.child2FirstInEdge[n] = this.child2FirstInEdge[n2];
            this.child2FirstInEdge[n2] = -1;
        }
    }

    private void changeParent(int n, int n2) {
        int n3 = this.parentNodes[n];
        byte by = this.symbols[n];
        assert (this.outEdges[by][n3] == n);
        assert (this.outEdges[by][n2] == -1);
        this.outEdges[by][n3] = -1;
        this.outEdges[by][n2] = n;
        this.parentNodes[n] = n2;
    }

    private void mergeEdges(int n, int n2) {
        assert (this.symbols[n] == this.symbols[n2]);
        assert (this.counts[n2] > 0.0f);
        int n3 = n;
        this.counts[n3] = this.counts[n3] + this.counts[n2];
        if (this.nextLevel == null) {
            this.mergeHaplotypes(this.childNodes[n], this.childNodes[n2]);
        }
        int n4 = this.parentNodes[n2];
        int n5 = this.childNodes[n2];
        byte by = this.symbols[n2];
        assert (this.inEdge2NextInEdge[this.child2FirstInEdge[n5]] == -1);
        this.outEdges[by][n4] = -1;
        this.child2FirstInEdge[n5] = -1;
        this.counts[n2] = 0.0f;
        this.parentNodes[n2] = -1;
        this.childNodes[n2] = -1;
        this.symbols[n2] = -1;
    }

    private void mergeHaplotypes(int n, int n2) {
        int n3 = this.child2FirstHap[n2];
        while (this.hap2NextHap[n3] != -1) {
            n3 = this.hap2NextHap[n3];
        }
        this.hap2NextHap[n3] = this.child2FirstHap[n];
        this.child2FirstHap[n] = this.child2FirstHap[n2];
        this.child2FirstHap[n2] = -1;
    }

    public Marker marker() {
        return this.marker;
    }

    public int markerIndex() {
        return this.markerIndex;
    }

    public int nHaps() {
        return this.nHaps;
    }

    public int nAlleles() {
        return this.nAlleles;
    }

    public float edgeCount(int n) {
        return this.counts[n];
    }

    public float nodeCount(int n) {
        float f = 0.0f;
        for (int i = 0; i < this.nAlleles; ++i) {
            if (this.outEdges[i][n] < 0) continue;
            f += this.edgeCount(this.outEdges[i][n]);
        }
        return f;
    }

    public int[] parentNodeArray() {
        int[] nArray = DagUtils.removeValues(this.parentNodes, -1);
        Arrays.sort(nArray);
        assert (nArray.length > 0);
        int n = 1;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray[i - 1]) continue;
            ++n;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        nArray2[n2++] = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray[i - 1]) continue;
            nArray2[n2++] = nArray[i];
        }
        assert (n2 == nArray2.length);
        return nArray2;
    }

    public int parentNode(int n) {
        return this.parentNodes[n];
    }

    public int childNode(int n) {
        return this.childNodes[n];
    }

    public int outEdge(int n, int n2) {
        return this.outEdges[n2][n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append(Const.nl);
        stringBuilder.append("[ MergeableDagLevel: marker=");
        stringBuilder.append(this.markerIndex);
        stringBuilder.append(Const.nl);
        int n = this.nHaps();
        for (int i = 0; i < n; ++i) {
            if (this.parentNodes[i] == -1) continue;
            stringBuilder.append("edge=");
            stringBuilder.append(i);
            stringBuilder.append(" parent=");
            stringBuilder.append(this.parentNodes[i]);
            stringBuilder.append(" child=");
            stringBuilder.append(this.childNodes[i]);
            stringBuilder.append(" symbol=");
            stringBuilder.append(this.symbols[i]);
            stringBuilder.append(" count=");
            stringBuilder.append(this.counts[i]);
            stringBuilder.append(Const.nl);
        }
        stringBuilder.append("previous=");
        stringBuilder.append(this.prevLevel != null);
        stringBuilder.append(" next=");
        stringBuilder.append(this.nextLevel != null);
        stringBuilder.append(Const.nl);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    private boolean isParentNode(int n) {
        if (this.prevLevel != null) {
            return this.prevLevel.child2FirstInEdge[n] >= 0;
        }
        for (int i = 0; i < this.nAlleles; ++i) {
            if (this.outEdges[i][n] == -1) continue;
            return true;
        }
        return false;
    }
}

