/*
 * Decompiled with CFR 0.152.
 */
package sample;

public class HapNodes {
    private static final float loadFactor = 0.75f;
    private int size = 0;
    private int capacity = 1024;
    private int rehashThreshold = (int)(0.75f * (float)this.capacity);
    private int[] index = new int[this.capacity];
    private int[] node = new int[this.capacity];
    private float[] value = new float[this.capacity];

    private int index(int n) {
        long l = 355 + n;
        long l2 = 679 + n;
        if ((l2 & 1L) == 0L) {
            ++l2;
        }
        for (int i = 0; i < this.capacity; ++i) {
            int n2 = (int)(l % (long)this.capacity);
            if ((double)this.value[n2] == 0.0 || this.node[n2] == n) {
                return n2;
            }
            l += l2;
        }
        assert (false);
        return -1;
    }

    private void rehash() {
        assert (this.size >= this.rehashThreshold);
        int n = 2 * this.capacity;
        if (n < 0) {
            throw new IllegalStateException("hash table overflow");
        }
        int[] nArray = this.index;
        int[] nArray2 = this.node;
        float[] fArray = this.value;
        this.capacity = n;
        this.index = new int[n];
        this.node = new int[n];
        this.value = new float[n];
        for (int i = 0; i < this.size; ++i) {
            int n2;
            int n3 = nArray[i];
            this.index[i] = n2 = this.index(nArray2[n3]);
            this.node[n2] = nArray2[n3];
            this.value[n2] = fArray[n3];
        }
        this.rehashThreshold = (int)(0.75f * (float)this.capacity);
    }

    public void sumUpdate(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (f <= 0.0f || !Double.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        int n2 = this.index(n);
        boolean bl = this.value[n2] == 0.0f;
        int n3 = n2;
        this.value[n3] = this.value[n3] + f;
        if (bl) {
            this.index[this.size++] = n2;
            this.node[n2] = n;
            if (this.size >= this.rehashThreshold) {
                this.rehash();
            }
        }
    }

    public int size() {
        return this.size;
    }

    private void checkSize(int n) {
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
    }

    public int enumNode(int n) {
        this.checkSize(n);
        return this.node[this.index[n]];
    }

    public float enumValue(int n) {
        this.checkSize(n);
        return this.value[this.index[n]];
    }

    public float value(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return this.value[this.index(n)];
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.value[this.index[i]] = 0.0f;
        }
        this.size = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("size=");
        stringBuilder.append(this.size);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(" (");
            stringBuilder.append(i);
            stringBuilder.append(": node=");
            stringBuilder.append(this.enumNode(i));
            stringBuilder.append(" value=");
            stringBuilder.append(this.enumValue(i));
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }
}

