\name{plot.vario}
\alias{plot.vario}
\title{
Plot \code{vario} objects
}
\description{
Plot \code{vario} objects
}
\usage{
\method{plot}{vario} (x, xlab = "Lag distance", ylab = NULL, ylim = NULL,
                      xtype = c("mean.bin.dist", "bins"), rug = FALSE, ci = FALSE,
                      pch = 21, col.sig="black", col.nonsig="black", bg.sig="black", 
                      bg.nonsig = "white", alpha = 0.05, \dots)
}
\arguments{
  \item{x}{
\code{vario} object generated by \code{vario} function.
}
  \item{xlab}{
xlabel of the figure. Default is "Lag distance"
}
  \item{ylab}{
ylabel of the figure. Default is \code{NULL} and will automatically generate the right label
}
  \item{ylim}{
y-range. Default is \code{NULL} and will automatically generate the best range based on the metric
}
  \item{xtype}{
Use either the discrete bin classes (\code{bins}) or 
the mean distance of the points within each bin (\code{mean.bin.dist}) on the x-axis. 
Default is \code{mean.bin.dist}
}
\item{rug}{
Plot rug indicating the density of data points? Default is \code{FALSE}
}
\item{ci}{
Plot two-tailed (1-\eqn{\alpha})\% confidence intervals? Default is \code{FALSE}
}
  \item{pch}{
Type of points to use when plotting the variogram. Default is 21
}
\item{col.sig}{
Border color of points for significant values. Default is black
}
\item{col.nonsig}{
Border color of points for non-significant values. Default is black
}
\item{bg.sig}{
Background color of points for significant values. Default is black
}
\item{bg.nonsig}{
Background color of points for non-significant values. Default is black
}
\item{alpha}{
Significance level. Default is 0.05
}
  \item{\dots}{
other graphical parameters.
}
}

\author{
Tarik C. Gouhier (tarik.gouhier@gmail.com)
}

\examples{
data(pisco.data)
d=subset(pisco.data, subset=year==2000, select=c("latitude", "longitude", "sst"))
semiv=vario(data=d)
moran=vario(data=d, type="moran", nrand=100)
geary=vario(data=d, type="geary", nrand=100)

par(mfrow=c(3,1))
plot(semiv)
plot(moran, bg.sig="blue")
plot(geary, bg.sig="red")
}
