% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{evaluate.basis}
\alias{evaluate.basis}
\title{Evaluate Orthonormal Basis Functions}
\usage{
evaluate.basis(
  K,
  m = 51,
  domain = c(0, 1),
  grid = seq(domain[1], domain[2], length.out = m),
  type = c("FOURIER", "COS", "SIN", "LEGENDRE")
)
}
\arguments{
\item{K}{positive integer specifying the number of basis functions to be included}

\item{m}{number of equispaced points on \code{domain}.}

\item{domain}{domain on which basis functions are defined.}

\item{grid}{vector specifying the time points to evaluate the basis functions; if \code{grid} is specified, then \code{m} is ignored.}

\item{type}{string for the type of orthogonal basis.}
}
\value{
A \code{m} by \code{K} matrix, where rows index basis functions while columns index points in the grid.
}
\description{
Evaluate Orthonormal Basis Functions
}
\examples{
basis <- evaluate.basis(3, type='fourier')
head(basis)

}
