% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_annealing.R
\name{add_constraint}
\alias{add_constraint}
\title{Add new constraint to constraint table}
\usage{
add_constraint(attr_name = "variable", attr_totals, micro_data,
  constraint_list = NULL)
}
\arguments{
\item{attr_name}{The name of the attribute, or variable, that you wish to constrain.}

\item{attr_totals}{A named integer vector of counts per level of the new constraining attribute.}

\item{micro_data}{The micro dataset, of class \code{"micro_synthetic"}, for which you wish to
add a constraint.}

\item{constraint_list}{A \code{list} of prior constraints on the same dataset which you wish to
add to. Defaults to \code{NULL} (ie. the default is that this is the first constraint.)}
}
\value{
A list of constraints.
}
\description{
Add a new constraint to the mapping between a given macro dataset (class "macroACS")
and a matching micro dataset (class "micro_synthetic). May be called repeatedly to create a 
set of constraints.
}
\examples{
\dontrun{
## assumes that you have a micro_synthetic dataset named test_micro and attribute counts
## named a,e,g respectively 
c_list <- add_constraint(attr_name= "age", attr_totals= a, micro_data= test_micro)
c_list <- add_constraint(attr_name= "edu_attain", attr_totals= e, micro_data= test_micro,
                        constraint_list= c_list)
c_list <- add_constraint(attr_name= "gender", attr_totals= g, micro_data= test_micro,
                         constraint_list= c_list)
}
}
