% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExponentialFitnessLinkFun.R
\name{Model.fitness.conditionalmeandegree}
\alias{Model.fitness.conditionalmeandegree}
\title{Mean out-degree of a node with given fitness in the fitness model}
\usage{
Model.fitness.conditionalmeandegree(x, alpha, beta, gamma = 1)
}
\arguments{
\item{x}{Fitness of node. A nonegative number.}

\item{alpha}{Exponent of the power law of the degree distribution. Must be <0.}

\item{beta}{Lower endpoint of the relative expected out degree
(expected out degree divided by n-1). Must be >=0.}

\item{gamma}{Upper endpoint of the relative expected out degree
(expected out degree divided by n-1). Must be at least beta and at most 1.}
}
\description{
Computes the mean out-degree of a node with given fitness \code{x}
in the fitness model implemented in
\code{\link{Model.additivelink.exponential.fitness}}. The function
returns the mean out-degree divided by n-1.
}

