% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_ErdosRenyExponential_MCMC.R
\name{steps_ERE}
\alias{steps_ERE}
\title{Perform Steps of the Gibbs Sampler of the ERE model}
\usage{
steps_ERE(L, p, lambda, nsamples = 10000, thin = 1000, burnin = 10000)
}
\arguments{
\item{L}{Starting matrix for the Gibbs sampler. Implicitly defines the fixed marginals.}

\item{p}{A matrix with entries in [0,1]}

\item{lambda}{A matrix with nonnegative entries}

\item{nsamples}{Number of samples to return.}

\item{thin}{Frequency at which samples should be generated (default=1, every step)}

\item{burnin}{Number of initial steps to discard.}
}
\value{
List of simulation results
}
\description{
Runs a Gibbs sampler in the Erdos Reny model with Exponential weights (ERE model)
and fixed marginals. The algorithm starts from a given matrix.
}
\examples{
L <- matrix(rexp(4*4),nrow=4,ncol=4); diag(L)=0;
p <- matrix(0.5,nrow=4,ncol=4); diag(p) <-0;
lambda <- matrix(1,nrow=4,ncol=4); diag(lambda)<-0;

L <- steps_ERE(L=L,p=p,lambda=lambda,nsamples=5,thin=50,burnin=20)
L

}
\seealso{
\code{\link{sample_ERE}}
}

