% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syuzhet.R
\name{mixed_messages}
\alias{mixed_messages}
\title{Mixed Messages}
\usage{
mixed_messages(string, remove_neutral = TRUE)
}
\arguments{
\item{string}{A string of words}

\item{remove_neutral}{Logical indicating whether or not to remove words with neutral valence before computing the emotional entropy of the string.  Default is TRUE}
}
\value{
A \code{\link[base]{vector}} containing two named values
}
\description{
This function calculates the "emotional entropy" of a string based on the amount of conflicting valence. Emotional entropy is a measure of unpredictability and surprise based on the consistency or inconsistency of the emotional language in a given string. A string with conflicting emotional language may be said to express a "mixed message."
}
\examples{
text_v <- "That's the love and the hate of it" 
mixed_messages(text_v) # [1] 1.0 0.5 = high (1.0, 0.5) entropy
mixed_messages(text_v, TRUE)
# Example of a predictable message i.e. no surprise
text_v <- "I absolutley love, love, love it." 
mixed_messages(text_v) # [1] 0 0 = low entropy e.g. totally consistent emotion, i.e. no surprise
mixed_messages(text_v, FALSE)
# A more realistic example with a lot of mixed emotion.
text_v <- "I loved the way he looked at me but I hated that he was no longer my lover"
mixed_messages(text_v) # [1] 0.91829583 0.05101644 pretty high entropy.
mixed_messages(text_v, FALSE)
# A more realistic example without a lot of mixed emotion.
text_v <- "I loved the way he looked at me and I was happy that he was my lover."
mixed_messages(text_v) # [1] 0 0 low entropy, no surprise.
mixed_messages(text_v, FALSE)
# An urealistic example with a lot of mixed emotion.
text_v <- "I loved, hated and despised the way he looked at me and 
I was happy as hell that he was my white hot lover."
mixed_messages(text_v)
mixed_messages(text_v, FALSE)
}
