% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.ratings.R
\name{trakt.movie.ratings}
\alias{trakt.movie.ratings}
\title{Get a single movie's ratings}
\usage{
trakt.movie.ratings(target)
}
\arguments{
\item{target}{The \code{id} of the movie requested. Either the \code{slug}
(e.g. \code{"tron-legacy-2010"}), \code{trakt id} or \code{IMDb id}}
}
\value{
A \code{list} containing movie ratings and distribution
}
\description{
\code{trakt.movie.ratings} returns a single movie's rating and distribution.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/movies/ratings/get-movie-ratings}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.movie.ratings("tron-legacy-2010")
}
}
\seealso{
Other movie data: \code{\link{trakt.movie.people}};
  \code{\link{trakt.movie.releases}};
  \code{\link{trakt.movie.summary}};
  \code{\link{trakt.movie.watching}};
  \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.related}};
  \code{\link{trakt.movies.trending}};
  \code{\link{trakt.stats}}
}

