% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.show.summary.R
\name{trakt.show.summary}
\alias{trakt.show.summary}
\title{Get show summary info}
\usage{
trakt.show.summary(target, extended = "full")
}
\arguments{
\item{target}{The \code{slug} of the show requested, e.g. \code{game-of-thrones}}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"full"}, can either be \code{"min"} or \code{"full"}}
}
\value{
A \code{list} containing summary info
}
\description{
\code{trakt.show.summary} pulls show summary data and returns it compactly.
}
\details{
Note that setting \code{extended} to \code{min} makes this function
return about as much informations as \link[tRakt]{trakt.search}
}
\note{
See \href{http://docs.trakt.apiary.io/reference/shows/summary}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad.summary_full <- trakt.show.summary("breaking-bad")
}
}

