\name{formatp}
\alias{formatp}
\title{
Format p-values for the functions in the package tab
}
\description{
This function formats p-values for tables generated by the functions in the package tab. It handles rounding and presentation of p-values.
}
\usage{
formatp(p, decimals = c(2, 3), cuts = 0.01, lowerbound = 0.001, 
        leading0 = TRUE, avoid1 = FALSE)
}
\arguments{
  \item{p}{
Numeric value or vector of p-values. 
}
  \item{decimals}{
Number of decimal places for p-values. If a vector is provided rather than a single value, number of decimal places will depend on what range the p-value lies in. See cuts.
}
  \item{cuts}{
Cut-point(s) to control number of decimal places used for p-values. For example, by default cuts is 0.1 and decimals is c(2,3). This means that p-values in the range [0.1, 1] will be printed to two decimal places, while p-values in the range [0, 0.1) will be printed to three decimal places.
}
  \item{lowerbound}{
Controls cut-point at which p-values are no longer printed as their value, but rather <lowerbound. For example, by default lowerbound is 0.001. Under this setting, p-values less than 0.001 are printed as <0.001.
}
  \item{leading0}{
If TRUE, p-values are printed with 0 before decimal place; if FALSE, the leading 0 is omitted.
}
  \item{avoid1}{
If TRUE, p-values rounded to 1 are not printed as 1, but as >0.99 (or similarly depending on values for decimals and cuts).
}
}
\details{
NA
}
\value{
Character value or vector.
}
\references{
Acknowledgment: This material is based upon work supported by the National Science Foundation Graduate Research Fellowship under Grant No. DGE-0940903.
}
\author{
Dane R. Van Domelen
}
\note{
NA
}
\seealso{
NA
}
\examples{
# Generate vector of numeric p-values
set.seed(123)
p <- c(runif(n = 5, min = 0, max = 1), 1, 0, 4e-7, 0.009)

# Round to nearest 2 decimals for p in (0.01, 1] and 3 decimals for p < 0.01
pvals <- formatp(p = p)

# Use 2 decimal places, a lower bound of 0.01, and omit the leading 0.
pvals <- formatp(p = p, decimals = 2, lowerbound = 0.01, leading0 = FALSE)
}
\keyword{ p }
\keyword{ p-values }